/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.dao.home;

import com.publiccms.common.base.BaseDao;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.handler.QueryHandler;
import com.publiccms.common.tools.CommonUtils;
import org.publiccms.entities.home.HomeGroupPost;
import org.springframework.stereotype.Repository;

@Repository
public class HomeGroupPostDao
extends BaseDao<HomeGroupPost> {
    public PageHandler getPage(Integer siteId, Long groupId, Long userId, Boolean disabled, String orderField, String orderType, Integer pageIndex, Integer pageSize) {
        QueryHandler queryHandler = HomeGroupPostDao.getQueryHandler("from HomeGroupPost bean");
        if (CommonUtils.notEmpty(siteId)) {
            queryHandler.condition("bean.siteId = :siteId").setParameter("siteId", siteId);
        }
        if (CommonUtils.notEmpty(groupId)) {
            queryHandler.condition("bean.groupId = :groupId").setParameter("groupId", groupId);
        }
        if (CommonUtils.notEmpty(userId)) {
            queryHandler.condition("bean.userId = :userId").setParameter("userId", userId);
        }
        if (CommonUtils.notEmpty(disabled)) {
            queryHandler.condition("bean.disabled = :disabled").setParameter("disabled", disabled);
        }
        if (!"asc".equalsIgnoreCase(orderType)) {
            orderType = "desc";
        }
        if (null == orderField) {
            orderField = "";
        }
        switch (orderField) {
            case "scores": {
                queryHandler.order("bean.scores " + orderType);
                break;
            }
            case "comments": {
                queryHandler.order("bean.comments " + orderType);
                break;
            }
            case "clicks": {
                queryHandler.order("bean.clicks " + orderType);
                break;
            }
            case "createDate": {
                queryHandler.order("bean.createDate " + orderType);
                break;
            }
            default: {
                queryHandler.order("bean.id " + orderType);
            }
        }
        return this.getPage(queryHandler, pageIndex, pageSize);
    }

    @Override
    protected HomeGroupPost init(HomeGroupPost entity) {
        if (CommonUtils.empty(entity.getCreateDate())) {
            entity.setCreateDate(CommonUtils.getDate());
        }
        return entity;
    }
}

