/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.dao.home;

import com.publiccms.common.base.BaseDao;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.handler.QueryHandler;
import com.publiccms.common.tools.CommonUtils;
import org.publiccms.entities.home.HomeFile;
import org.springframework.stereotype.Repository;

@Repository
public class HomeFileDao
extends BaseDao<HomeFile> {
    public PageHandler getPage(Integer siteId, Long userId, Long directoryId, String title, String filePath, Boolean image, Boolean disabled, String orderField, String orderType, Integer pageIndex, Integer pageSize) {
        QueryHandler queryHandler = HomeFileDao.getQueryHandler("from HomeFile bean");
        if (CommonUtils.notEmpty(siteId)) {
            queryHandler.condition("bean.siteId = :siteId").setParameter("siteId", siteId);
        }
        if (CommonUtils.notEmpty(userId)) {
            queryHandler.condition("bean.userId = :userId").setParameter("userId", userId);
        }
        if (CommonUtils.notEmpty(directoryId)) {
            queryHandler.condition("bean.directoryId = :directoryId").setParameter("directoryId", directoryId);
        }
        if (CommonUtils.notEmpty(title)) {
            queryHandler.condition("bean.title like :title").setParameter("title", HomeFileDao.like(title));
        }
        if (CommonUtils.notEmpty(filePath)) {
            queryHandler.condition("bean.filePath = :filePath").setParameter("filePath", filePath);
        }
        if (CommonUtils.notEmpty(image)) {
            queryHandler.condition("bean.image = :image").setParameter("image", image);
        }
        if (CommonUtils.notEmpty(disabled)) {
            queryHandler.condition("bean.disabled = :disabled").setParameter("disabled", disabled);
        }
        if (!"asc".equalsIgnoreCase(orderType)) {
            orderType = "desc";
        }
        if (null == orderField) {
            orderField = "";
        }
        switch (orderField) {
            case "fileSize": {
                queryHandler.order("bean.fileSize " + orderType);
                break;
            }
            case "scores": {
                queryHandler.order("bean.scores " + orderType);
                break;
            }
            case "comments": {
                queryHandler.order("bean.comments " + orderType);
                break;
            }
            case "createDate": {
                queryHandler.order("bean.createDate " + orderType);
                break;
            }
            default: {
                queryHandler.order("bean.id " + orderType);
            }
        }
        return this.getPage(queryHandler, pageIndex, pageSize);
    }

    @Override
    protected HomeFile init(HomeFile entity) {
        if (CommonUtils.empty(entity.getCreateDate())) {
            entity.setCreateDate(CommonUtils.getDate());
        }
        return entity;
    }
}

