/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.dao.home;

import com.publiccms.common.base.BaseDao;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.handler.QueryHandler;
import com.publiccms.common.tools.CommonUtils;
import org.publiccms.entities.home.HomeBroadcast;
import org.springframework.stereotype.Repository;

@Repository
public class HomeBroadcastDao
extends BaseDao<HomeBroadcast> {
    public PageHandler getPage(Integer siteId, Long userId, Boolean reposted, Long repostId, Boolean disabled, String orderField, String orderType, Integer pageIndex, Integer pageSize) {
        QueryHandler queryHandler = HomeBroadcastDao.getQueryHandler("from HomeBroadcast bean");
        if (CommonUtils.notEmpty(siteId)) {
            queryHandler.condition("bean.siteId = :siteId").setParameter("siteId", siteId);
        }
        if (CommonUtils.notEmpty(userId)) {
            queryHandler.condition("bean.userId = :userId").setParameter("userId", userId);
        }
        if (CommonUtils.notEmpty(reposted)) {
            queryHandler.condition("bean.reposted = :reposted").setParameter("reposted", reposted);
        }
        if (CommonUtils.notEmpty(repostId)) {
            queryHandler.condition("bean.repostId = :repostId").setParameter("repostId", repostId);
        }
        if (CommonUtils.notEmpty(disabled)) {
            queryHandler.condition("bean.disabled = :disabled").setParameter("disabled", disabled);
        }
        if (!"asc".equalsIgnoreCase(orderType)) {
            orderType = "desc";
        }
        if (null == orderField) {
            orderField = "";
        }
        switch (orderField) {
            case "scores": {
                queryHandler.order("bean.scores " + orderType);
                break;
            }
            case "reposts": {
                queryHandler.order("bean.reposts " + orderType);
                break;
            }
            case "comments": {
                queryHandler.order("bean.comments " + orderType);
                break;
            }
            case "message": {
                queryHandler.order("bean.message " + orderType);
                break;
            }
            case "createDate": {
                queryHandler.order("bean.createDate " + orderType);
                break;
            }
            default: {
                queryHandler.order("bean.id " + orderType);
            }
        }
        return this.getPage(queryHandler, pageIndex, pageSize);
    }

    @Override
    protected HomeBroadcast init(HomeBroadcast entity) {
        if (CommonUtils.empty(entity.getCreateDate())) {
            entity.setCreateDate(CommonUtils.getDate());
        }
        return entity;
    }
}

