/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.dao.cms;

import com.publiccms.common.base.BaseDao;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.handler.QueryHandler;
import com.publiccms.common.tools.CommonUtils;
import java.util.Date;
import org.publiccms.entities.cms.CmsWord;
import org.springframework.stereotype.Repository;

@Repository
public class CmsWordDao
extends BaseDao<CmsWord> {
    public PageHandler getPage(Integer siteId, Boolean hidden, Date startCreateDate, Date endCreateDate, String name, String orderField, String orderType, Integer pageIndex, Integer pageSize) {
        QueryHandler queryHandler = CmsWordDao.getQueryHandler("from CmsWord bean");
        if (CommonUtils.notEmpty(siteId)) {
            queryHandler.condition("bean.siteId = :siteId").setParameter("siteId", siteId);
        }
        if (CommonUtils.notEmpty(hidden)) {
            queryHandler.condition("bean.hidden = :hidden").setParameter("hidden", hidden);
        }
        if (CommonUtils.notEmpty(startCreateDate)) {
            queryHandler.condition("bean.createDate > :startCreateDate").setParameter("startCreateDate", startCreateDate);
        }
        if (CommonUtils.notEmpty(endCreateDate)) {
            queryHandler.condition("bean.createDate <= :endCreateDate").setParameter("endCreateDate", endCreateDate);
        }
        if (CommonUtils.notEmpty(name)) {
            queryHandler.condition("bean.name like :name").setParameter("name", CmsWordDao.like(name));
        }
        if (!"asc".equalsIgnoreCase(orderType)) {
            orderType = "desc";
        }
        if (null == orderField) {
            orderField = "";
        }
        switch (orderField) {
            case "searchCount": {
                queryHandler.order("bean.searchCount " + orderType);
                break;
            }
            case "createDate": {
                queryHandler.order("bean.createDate " + orderType);
                break;
            }
            default: {
                queryHandler.order("bean.id " + orderType);
            }
        }
        return this.getPage(queryHandler, pageIndex, pageSize);
    }

    public CmsWord getEntity(int siteId, String name) {
        if (CommonUtils.notEmpty(name)) {
            QueryHandler queryHandler = CmsWordDao.getQueryHandler("from CmsWord bean");
            queryHandler.condition("bean.siteId = :siteId").setParameter("siteId", siteId);
            queryHandler.condition("bean.name = :name").setParameter("name", name);
            return (CmsWord)this.getEntity(queryHandler);
        }
        return null;
    }

    @Override
    protected CmsWord init(CmsWord entity) {
        if (CommonUtils.empty(entity.getCreateDate())) {
            entity.setCreateDate(CommonUtils.getDate());
        }
        if (CommonUtils.notEmpty(entity.getName()) && entity.getName().length() > 255) {
            entity.setName(entity.getName().substring(0, 255));
        }
        return entity;
    }
}

