/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.dao.cms;

import com.publiccms.common.base.BaseDao;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.handler.QueryHandler;
import com.publiccms.common.tools.CommonUtils;
import org.publiccms.entities.cms.CmsTag;
import org.springframework.stereotype.Repository;

@Repository
public class CmsTagDao
extends BaseDao<CmsTag> {
    public PageHandler getPage(Integer siteId, Integer typeId, String name, String orderField, String orderType, Integer pageIndex, Integer pageSize) {
        QueryHandler queryHandler = CmsTagDao.getQueryHandler("from CmsTag bean");
        if (CommonUtils.notEmpty(siteId)) {
            queryHandler.condition("bean.siteId = :siteId").setParameter("siteId", siteId);
        }
        if (CommonUtils.notEmpty(typeId)) {
            queryHandler.condition("bean.typeId = :typeId").setParameter("typeId", typeId);
        }
        if (CommonUtils.notEmpty(name)) {
            queryHandler.condition("bean.name like :name").setParameter("name", CmsTagDao.rightLike(name));
        }
        if (!"asc".equalsIgnoreCase(orderType)) {
            orderType = "desc";
        }
        if (null == orderField) {
            orderField = "";
        }
        switch (orderField) {
            case "searchCount": {
                queryHandler.order("bean.searchCount " + orderType);
                break;
            }
            default: {
                queryHandler.order("bean.id " + orderType);
            }
        }
        return this.getPage(queryHandler, pageIndex, pageSize);
    }

    @Override
    protected CmsTag init(CmsTag entity) {
        return entity;
    }
}

