/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.dao.cms;

import com.publiccms.common.base.BaseDao;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.handler.QueryHandler;
import com.publiccms.common.tools.CommonUtils;
import java.util.Date;
import org.publiccms.entities.cms.CmsPlace;
import org.springframework.stereotype.Repository;

@Repository
public class CmsPlaceDao
extends BaseDao<CmsPlace> {
    public PageHandler getPage(Integer siteId, Long userId, String path, String itemType, Integer itemId, Date startPublishDate, Date endPublishDate, Integer status, Boolean disabled, String orderField, String orderType, Integer pageIndex, Integer pageSize) {
        QueryHandler queryHandler = CmsPlaceDao.getQueryHandler("from CmsPlace bean");
        if (CommonUtils.notEmpty(siteId)) {
            queryHandler.condition("bean.siteId = :siteId").setParameter("siteId", siteId);
        }
        if (CommonUtils.notEmpty(userId)) {
            queryHandler.condition("bean.userId = :userId").setParameter("userId", userId);
        }
        if (CommonUtils.notEmpty(path)) {
            queryHandler.condition("bean.path = :path").setParameter("path", path);
        }
        if (CommonUtils.notEmpty(itemType)) {
            queryHandler.condition("bean.itemType = :itemType").setParameter("itemType", itemType);
        }
        if (CommonUtils.notEmpty(itemId)) {
            queryHandler.condition("bean.itemId = :itemId").setParameter("itemId", itemId);
        }
        if (CommonUtils.notEmpty(startPublishDate)) {
            queryHandler.condition("bean.publishDate > :startPublishDate").setParameter("startPublishDate", startPublishDate);
        }
        if (CommonUtils.notEmpty(endPublishDate)) {
            queryHandler.condition("bean.publishDate <= :endPublishDate").setParameter("endPublishDate", endPublishDate);
        }
        if (CommonUtils.notEmpty(status)) {
            queryHandler.condition("bean.status = :status").setParameter("status", status);
        }
        if (CommonUtils.notEmpty(disabled)) {
            queryHandler.condition("bean.disabled = :disabled").setParameter("disabled", disabled);
        }
        if (!"asc".equalsIgnoreCase(orderType)) {
            orderType = "desc";
        }
        if (null == orderField) {
            orderField = "";
        }
        switch (orderField) {
            case "createDate": {
                queryHandler.order("bean.createDate " + orderType);
                break;
            }
            case "clicks": {
                queryHandler.order("bean.clicks " + orderType);
                break;
            }
            default: {
                queryHandler.order("bean.publishDate " + orderType);
            }
        }
        return this.getPage(queryHandler, pageIndex, pageSize);
    }

    public int delete(int siteId, String path) {
        if (CommonUtils.notEmpty(path)) {
            QueryHandler queryHandler = CmsPlaceDao.getDeleteQueryHandler("from CmsPlace bean");
            queryHandler.condition("bean.siteId = :siteId").setParameter("siteId", siteId);
            queryHandler.condition("bean.path = :path").setParameter("path", path);
            return this.delete(queryHandler);
        }
        return 0;
    }

    @Override
    protected CmsPlace init(CmsPlace entity) {
        if (CommonUtils.empty(entity.getCreateDate())) {
            entity.setCreateDate(CommonUtils.getDate());
        }
        if (CommonUtils.empty(entity.getPublishDate())) {
            entity.setPublishDate(CommonUtils.getDate());
        }
        return entity;
    }
}

