/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.dao.cms;

import com.publiccms.common.base.BaseDao;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.handler.QueryHandler;
import com.publiccms.common.tools.CommonUtils;
import org.publiccms.entities.cms.CmsContentFile;
import org.springframework.stereotype.Repository;

@Repository
public class CmsContentFileDao
extends BaseDao<CmsContentFile> {
    public PageHandler getPage(Long contentId, Long userId, Boolean image, String orderField, String orderType, Integer pageIndex, Integer pageSize) {
        QueryHandler queryHandler = CmsContentFileDao.getQueryHandler("from CmsContentFile bean");
        if (CommonUtils.notEmpty(contentId)) {
            queryHandler.condition("bean.contentId = :contentId").setParameter("contentId", contentId);
        }
        if (CommonUtils.notEmpty(userId)) {
            queryHandler.condition("bean.userId = :userId").setParameter("userId", userId);
        }
        if (CommonUtils.notEmpty(image)) {
            queryHandler.condition("bean.image = :image").setParameter("image", image);
        }
        if (!"asc".equalsIgnoreCase(orderType)) {
            orderType = "desc";
        }
        if (null == orderField) {
            orderField = "";
        }
        switch (orderField) {
            case "size": {
                queryHandler.order("bean.size " + orderType);
                break;
            }
            case "clicks": {
                queryHandler.order("bean.clicks " + orderType);
                break;
            }
            default: {
                queryHandler.order("bean.sort asc,bean.id asc");
            }
        }
        return this.getPage(queryHandler, pageIndex, pageSize);
    }

    @Override
    protected CmsContentFile init(CmsContentFile entity) {
        return entity;
    }
}

