/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.dao.cms;

import com.publiccms.common.base.BaseDao;
import com.publiccms.common.handler.FacetPageHandler;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.handler.QueryHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.hibernate.search.FullTextQuery;
import org.publiccms.entities.cms.CmsContent;
import org.springframework.stereotype.Repository;

@Repository
public class CmsContentDao
extends BaseDao<CmsContent> {
    private static final String[] textFields = new String[]{"title", "author", "editor", "description"};
    private static final String[] tagFields = new String[]{"tagIds"};
    private static final String[] facetFields = new String[]{"categoryId", "modelId", "userId"};

    public PageHandler query(Integer siteId, String text, String tagId, Integer pageIndex, Integer pageSize) {
        FullTextQuery query = CommonUtils.notEmpty(tagId) ? this.getQuery(tagFields, tagId) : this.getQuery(textFields, text);
        query.enableFullTextFilter("publishDate").setParameter("publishDate", (Object)CommonUtils.getDate());
        query.enableFullTextFilter("siteId").setParameter("siteId", (Object)siteId);
        return this.getPage(query, pageIndex, pageSize);
    }

    public FacetPageHandler facetQuery(Integer siteId, String[] categoryIds, String[] modelIds, String[] userIds, String text, String tagId, Integer pageIndex, Integer pageSize) {
        FullTextQuery query = CommonUtils.notEmpty(tagId) ? this.getFacetQuery(tagFields, facetFields, tagId, 10) : this.getFacetQuery(textFields, facetFields, text, 10);
        query.enableFullTextFilter("publishDate").setParameter("publishDate", (Object)CommonUtils.getDate());
        query.enableFullTextFilter("siteId").setParameter("siteId", (Object)siteId);
        HashMap<String, List<String>> valueMap = new HashMap<String, List<String>>();
        if (CommonUtils.notEmpty(categoryIds)) {
            valueMap.put("categoryId", Arrays.asList(categoryIds));
        }
        if (CommonUtils.notEmpty(modelIds)) {
            valueMap.put("modelId", Arrays.asList(modelIds));
        }
        if (CommonUtils.notEmpty(userIds)) {
            valueMap.put("userId", Arrays.asList(userIds));
        }
        return this.getFacetPage(query, facetFields, valueMap, pageIndex, pageSize);
    }

    public int deleteByCategoryIds(int siteId, Integer[] categoryIds) {
        if (CommonUtils.notEmpty(categoryIds)) {
            QueryHandler queryHandler = CmsContentDao.getQueryHandler("update CmsContent bean set bean.disabled = :disabled");
            queryHandler.condition("bean.siteId = :siteId").setParameter("siteId", siteId);
            queryHandler.condition("bean.categoryId in (:categoryIds)").setParameter("categoryIds", categoryIds).setParameter("disabled", true);
            return this.update(queryHandler);
        }
        return 0;
    }

    public void index(int siteId, Serializable[] ids) {
        for (CmsContent entity : this.getEntitys(ids)) {
            if (siteId != entity.getSiteId()) continue;
            this.index(entity);
        }
    }

    public PageHandler getPage(Integer siteId, Integer[] status, Integer categoryId, Integer[] categoryIds, Boolean disabled, String[] modelIds, Long parentId, Boolean emptyParent, Boolean onlyUrl, Boolean hasImages, Boolean hasFiles, String title, Long userId, Long checkUserId, Date startPublishDate, Date endPublishDate, String orderField, String orderType, Integer pageIndex, Integer pageSize) {
        QueryHandler queryHandler = CmsContentDao.getQueryHandler("from CmsContent bean");
        if (CommonUtils.notEmpty(siteId)) {
            queryHandler.condition("bean.siteId = :siteId").setParameter("siteId", siteId);
        }
        if (CommonUtils.notEmpty(status)) {
            queryHandler.condition("bean.status in (:status)").setParameter("status", status);
        }
        if (CommonUtils.notEmpty(categoryIds)) {
            queryHandler.condition("bean.categoryId in (:categoryIds)").setParameter("categoryIds", categoryIds);
        } else if (CommonUtils.notEmpty(categoryId)) {
            queryHandler.condition("bean.categoryId = :categoryId").setParameter("categoryId", categoryId);
        }
        if (CommonUtils.notEmpty(disabled)) {
            queryHandler.condition("bean.disabled = :disabled").setParameter("disabled", disabled);
        }
        if (CommonUtils.notEmpty(modelIds)) {
            queryHandler.condition("bean.modelId in (:modelIds)").setParameter("modelIds", modelIds);
        }
        if (CommonUtils.notEmpty(parentId)) {
            queryHandler.condition("bean.parentId = :parentId").setParameter("parentId", parentId);
        } else if (CommonUtils.notEmpty(emptyParent) && emptyParent.booleanValue()) {
            queryHandler.condition("bean.parentId is null");
        }
        if (CommonUtils.notEmpty(onlyUrl)) {
            queryHandler.condition("bean.onlyUrl = :onlyUrl").setParameter("onlyUrl", onlyUrl);
        }
        if (CommonUtils.notEmpty(hasImages)) {
            queryHandler.condition("bean.hasImages = :hasImages").setParameter("hasImages", hasImages);
        }
        if (CommonUtils.notEmpty(hasFiles)) {
            queryHandler.condition("bean.hasFiles = :hasFiles").setParameter("hasFiles", hasFiles);
        }
        if (CommonUtils.notEmpty(title)) {
            queryHandler.condition("(bean.title like :title)").setParameter("title", CmsContentDao.like(title));
        }
        if (CommonUtils.notEmpty(userId)) {
            queryHandler.condition("bean.userId = :userId").setParameter("userId", userId);
        }
        if (CommonUtils.notEmpty(checkUserId)) {
            queryHandler.condition("bean.checkUserId = :checkUserId").setParameter("checkUserId", checkUserId);
        }
        if (CommonUtils.notEmpty(startPublishDate)) {
            queryHandler.condition("bean.publishDate > :startPublishDate").setParameter("startPublishDate", startPublishDate);
        }
        if (CommonUtils.notEmpty(endPublishDate)) {
            queryHandler.condition("bean.publishDate <= :endPublishDate").setParameter("endPublishDate", endPublishDate);
        }
        if (!"asc".equalsIgnoreCase(orderType)) {
            orderType = "desc";
        }
        if (null == orderField) {
            orderField = "";
        }
        switch (orderField) {
            case "scores": {
                queryHandler.order("bean.scores " + orderType);
                break;
            }
            case "comments": {
                queryHandler.order("bean.comments " + orderType);
                break;
            }
            case "clicks": {
                queryHandler.order("bean.clicks " + orderType);
                break;
            }
            case "publishDate": {
                queryHandler.order("bean.publishDate " + orderType);
                break;
            }
            case "default": {
                orderType = "desc";
            }
            default: {
                if ("desc".equals(orderType)) {
                    queryHandler.order("bean.sort desc");
                }
                queryHandler.order("bean.publishDate desc");
            }
        }
        queryHandler.order("bean.id desc");
        return this.getPage(queryHandler, pageIndex, pageSize);
    }

    @Override
    protected CmsContent init(CmsContent entity) {
        if (CommonUtils.empty(entity.getCreateDate())) {
            entity.setCreateDate(CommonUtils.getDate());
        }
        if (CommonUtils.empty(entity.getPublishDate())) {
            entity.setPublishDate(CommonUtils.getDate());
        }
        if (CommonUtils.empty(entity.getTagIds())) {
            entity.setTagIds(null);
        }
        if (CommonUtils.empty(entity.getAuthor())) {
            entity.setAuthor(null);
        }
        if (CommonUtils.empty(entity.getCover())) {
            entity.setCover(null);
        }
        return entity;
    }
}

