/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.component.template;

import com.publiccms.common.base.Base;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.FreeMarkerUtils;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModelException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.publiccms.common.api.Cache;
import org.publiccms.common.base.AbstractFreemarkerView;
import org.publiccms.common.base.AbstractTaskDirective;
import org.publiccms.common.base.AbstractTemplateDirective;
import org.publiccms.common.constants.CommonConstants;
import org.publiccms.common.tools.ExtendUtils;
import org.publiccms.entities.cms.CmsCategory;
import org.publiccms.entities.cms.CmsCategoryAttribute;
import org.publiccms.entities.cms.CmsCategoryModel;
import org.publiccms.entities.cms.CmsCategoryModelId;
import org.publiccms.entities.cms.CmsContent;
import org.publiccms.entities.cms.CmsContentAttribute;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.site.DirectiveComponent;
import org.publiccms.logic.component.site.SiteComponent;
import org.publiccms.logic.component.template.MetadataComponent;
import org.publiccms.logic.component.template.NoCacheDirective;
import org.publiccms.logic.service.cms.CmsCategoryAttributeService;
import org.publiccms.logic.service.cms.CmsCategoryModelService;
import org.publiccms.logic.service.cms.CmsCategoryService;
import org.publiccms.logic.service.cms.CmsContentAttributeService;
import org.publiccms.logic.service.cms.CmsContentService;
import org.publiccms.logic.service.cms.CmsPlaceService;
import org.publiccms.views.pojo.CmsPageMetadata;
import org.publiccms.views.pojo.CmsPlaceMetadata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

public class TemplateComponent
implements Cache {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static String INCLUDE_DIRECTORY = "include";
    private String directivePrefix;
    private Configuration adminConfiguration;
    private Configuration webConfiguration;
    private Configuration taskConfiguration;
    @Autowired
    private CmsContentAttributeService contentAttributeService;
    @Autowired
    private CmsCategoryAttributeService categoryAttributeService;
    @Autowired
    private CmsContentService contentService;
    @Autowired
    private CmsCategoryModelService categoryModelService;
    @Autowired
    private CmsCategoryService categoryService;
    @Autowired
    private SiteComponent siteComponent;
    @Autowired
    private MetadataComponent metadataComponent;
    @Autowired
    private CmsPlaceService placeService;

    public String createStaticFile(SysSite site, String templatePath, String filePath, Integer pageIndex, CmsPageMetadata metadata, Map<String, Object> model) throws IOException, TemplateException {
        if (CommonUtils.notEmpty(filePath)) {
            if (null == model) {
                model = new HashMap<String, Object>();
            }
            if (null == metadata) {
                metadata = this.metadataComponent.getTemplateMetadata(this.siteComponent.getWebTemplateFilePath() + templatePath);
            }
            model.put("metadata", metadata);
            AbstractFreemarkerView.exposeSite(model, site);
            filePath = FreeMarkerUtils.generateStringByString(filePath, this.webConfiguration, model);
            model.put("url", site.getSitePath() + filePath);
            if (CommonUtils.notEmpty(pageIndex) && 1 < pageIndex) {
                int index = filePath.lastIndexOf(46);
                filePath = filePath.substring(0, index) + '_' + pageIndex + filePath.substring(index, filePath.length());
            }
            FreeMarkerUtils.generateFileByFile(templatePath, this.siteComponent.getWebFilePath(site, filePath), this.webConfiguration, model);
        }
        return filePath;
    }

    public boolean createContentFile(SysSite site, CmsContent entity, CmsCategory category, CmsCategoryModel categoryModel) {
        if (null != site && null != entity) {
            if (null == category) {
                category = (CmsCategory)this.categoryService.getEntity(Integer.valueOf(entity.getCategoryId()));
            }
            if (null == categoryModel) {
                categoryModel = (CmsCategoryModel)this.categoryModelService.getEntity(new CmsCategoryModelId(entity.getCategoryId(), entity.getModelId()));
            }
            if (null != categoryModel && null != category && !entity.isOnlyUrl()) {
                try {
                    if (site.isUseStatic() && CommonUtils.notEmpty(categoryModel.getTemplatePath())) {
                        String url = site.getSitePath() + this.createContentFile(site, entity, category, true, SiteComponent.getFullFileName(site, categoryModel.getTemplatePath()), null, null);
                        this.contentService.updateUrl(entity.getId(), url, true);
                    } else {
                        HashMap<String, Object> model = new HashMap<String, Object>();
                        model.put("content", entity);
                        model.put("category", category);
                        model.put("site", site);
                        String url = site.getDynamicPath() + FreeMarkerUtils.generateStringByString(category.getContentPath(), this.webConfiguration, model);
                        this.contentService.updateUrl(entity.getId(), url, false);
                    }
                    return true;
                }
                catch (TemplateException | IOException e) {
                    this.log.error((Object)e.getMessage());
                    return false;
                }
            }
        }
        return false;
    }

    public String createContentFile(SysSite site, CmsContent entity, CmsCategory category, boolean createMultiContentPage, String templatePath, String filePath, Integer pageIndex) throws IOException, TemplateException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("content", entity);
        model.put("category", category);
        CmsContentAttribute attribute = (CmsContentAttribute)this.contentAttributeService.getEntity(entity.getId());
        if (null != attribute) {
            Map<String, String> map = ExtendUtils.getExtendMap(attribute.getData());
            map.put("text", attribute.getText());
            map.put("source", attribute.getSource());
            map.put("sourceUrl", attribute.getSourceUrl());
            map.put("wordCount", String.valueOf(attribute.getWordCount()));
            model.put("attribute", map);
        } else {
            model.put("attribute", attribute);
        }
        if (CommonUtils.empty(filePath)) {
            filePath = category.getContentPath();
        }
        if (null != attribute && CommonUtils.notEmpty(attribute.getText())) {
            String[] texts = StringUtils.splitByWholeSeparator((String)attribute.getText(), (String)CommonConstants.getDefaultPageBreakTag());
            if (createMultiContentPage) {
                for (int i = 1; i < texts.length; ++i) {
                    PageHandler page = new PageHandler(i + 1, 1, texts.length, null);
                    model.put("text", texts[i]);
                    model.put("page", page);
                    this.createStaticFile(site, templatePath, filePath, i + 1, null, model);
                }
                PageHandler page = new PageHandler(pageIndex, 1, texts.length, null);
                model.put("page", page);
                model.put("text", texts[page.getPageIndex() - 1]);
            } else {
                PageHandler page = new PageHandler(pageIndex, 1, texts.length, null);
                model.put("page", page);
                model.put("text", texts[page.getPageIndex() - 1]);
            }
        }
        return this.createStaticFile(site, templatePath, filePath, 1, null, model);
    }

    public boolean createCategoryFile(SysSite site, CmsCategory entity, Integer pageIndex, Integer totalPage) {
        if (entity.isOnlyUrl()) {
            this.categoryService.updateUrl(entity.getId(), entity.getPath(), false);
        } else if (CommonUtils.notEmpty(entity.getPath())) {
            try {
                if (site.isUseStatic() && CommonUtils.notEmpty(entity.getTemplatePath())) {
                    String url = site.getSitePath() + this.createCategoryFile(site, entity, SiteComponent.getFullFileName(site, entity.getTemplatePath()), entity.getPath(), pageIndex, totalPage);
                    this.categoryService.updateUrl(entity.getId(), url, true);
                } else {
                    HashMap<String, Object> model = new HashMap<String, Object>();
                    model.put("category", entity);
                    model.put("site", site);
                    String url = site.getDynamicPath() + FreeMarkerUtils.generateStringByString(entity.getPath(), this.webConfiguration, model);
                    this.categoryService.updateUrl(entity.getId(), url, false);
                }
            }
            catch (TemplateException | IOException e) {
                this.log.error((Object)e.getMessage());
                return false;
            }
            return true;
        }
        return false;
    }

    public String createCategoryFile(SysSite site, CmsCategory entity, String templatePath, String filePath, Integer pageIndex, Integer totalPage) throws IOException, TemplateException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        if (CommonUtils.empty(pageIndex)) {
            pageIndex = 1;
        }
        model.put("category", entity);
        CmsCategoryAttribute attribute = (CmsCategoryAttribute)this.categoryAttributeService.getEntity(entity.getId());
        if (null != attribute) {
            Map<String, String> map = ExtendUtils.getExtendMap(attribute.getData());
            map.put("title", attribute.getTitle());
            map.put("keywords", attribute.getKeywords());
            map.put("description", attribute.getDescription());
            model.put("attribute", map);
        } else {
            model.put("attribute", attribute);
        }
        if (CommonUtils.notEmpty(totalPage) && pageIndex + 1 <= totalPage) {
            for (int i = pageIndex + 1; i <= totalPage; ++i) {
                model.put("pageIndex", i);
                this.createStaticFile(site, templatePath, filePath, i, null, model);
            }
        }
        model.put("pageIndex", pageIndex);
        return this.createStaticFile(site, templatePath, filePath, 1, null, model);
    }

    private void exposePlace(SysSite site, String templatePath, CmsPlaceMetadata metadata, Map<String, Object> model) {
        int pageSize = 10;
        if (CommonUtils.notEmpty(metadata.getSize())) {
            pageSize = metadata.getSize();
        }
        if (pageSize > 0) {
            model.put("page", this.placeService.getPage(site.getId(), null, templatePath, null, null, null, CommonUtils.getDate(), 1, false, null, null, 1, pageSize));
        }
        model.put("metadata", metadata);
        AbstractFreemarkerView.exposeSite(model, site);
    }

    public void staticPlace(SysSite site, String templatePath, CmsPlaceMetadata metadata) throws IOException, TemplateException {
        if (CommonUtils.notEmpty(templatePath)) {
            HashMap<String, Object> model = new HashMap<String, Object>();
            this.exposePlace(site, templatePath, metadata, model);
            String placeTemplatePath = INCLUDE_DIRECTORY + templatePath;
            FreeMarkerUtils.generateFileByFile(SiteComponent.getFullFileName(site, placeTemplatePath), this.siteComponent.getWebFilePath(site, placeTemplatePath), this.webConfiguration, model);
        }
    }

    public String printPlace(SysSite site, String templatePath, CmsPlaceMetadata metadata) throws IOException, TemplateException {
        StringWriter writer = new StringWriter();
        this.printPlace(writer, site, templatePath, metadata);
        return writer.toString();
    }

    public void printPlace(Writer writer, SysSite site, String templatePath, CmsPlaceMetadata metadata) throws IOException, TemplateException {
        if (CommonUtils.notEmpty(templatePath)) {
            HashMap<String, Object> model = new HashMap<String, Object>();
            this.exposePlace(site, templatePath, metadata, model);
            FreeMarkerUtils.generateStringByFile(writer, SiteComponent.getFullFileName(site, INCLUDE_DIRECTORY + templatePath), this.webConfiguration, model);
        }
    }

    @Autowired
    private void init(FreeMarkerConfigurer freeMarkerConfigurer, DirectiveComponent directiveComponent) throws IOException, TemplateModelException {
        HashMap<String, Base> freemarkerVariables = new HashMap<String, Base>();
        this.adminConfiguration = freeMarkerConfigurer.getConfiguration();
        for (Map.Entry<String, AbstractTemplateDirective> entry : directiveComponent.getTemplateDirectiveMap().entrySet()) {
            freemarkerVariables.put(this.directivePrefix + entry.getKey(), entry.getValue());
        }
        freemarkerVariables.putAll(directiveComponent.getMethodMap());
        this.adminConfiguration.setAllSharedVariables((TemplateHashModelEx)new SimpleHash(freemarkerVariables, this.adminConfiguration.getObjectWrapper()));
        this.webConfiguration = new Configuration(Configuration.getVersion());
        File webFile = new File(this.siteComponent.getWebTemplateFilePath());
        webFile.mkdirs();
        this.webConfiguration.setDirectoryForTemplateLoading(webFile);
        TemplateComponent.copyConfig(this.adminConfiguration, this.webConfiguration);
        HashMap<String, NoCacheDirective> webFreemarkerVariables = new HashMap<String, NoCacheDirective>(freemarkerVariables);
        webFreemarkerVariables.put("noCache", new NoCacheDirective());
        this.webConfiguration.setAllSharedVariables((TemplateHashModelEx)new SimpleHash(webFreemarkerVariables, this.webConfiguration.getObjectWrapper()));
        this.taskConfiguration = new Configuration(Configuration.getVersion());
        File taskFile = new File(this.siteComponent.getTaskTemplateFilePath());
        taskFile.mkdirs();
        this.taskConfiguration.setDirectoryForTemplateLoading(taskFile);
        TemplateComponent.copyConfig(this.adminConfiguration, this.taskConfiguration);
        for (Map.Entry<String, AbstractTaskDirective> entry : directiveComponent.getTaskDirectiveMap().entrySet()) {
            freemarkerVariables.put(this.directivePrefix + entry.getKey(), entry.getValue());
        }
        this.taskConfiguration.setAllSharedVariables((TemplateHashModelEx)new SimpleHash(freemarkerVariables, this.taskConfiguration.getObjectWrapper()));
    }

    private static void copyConfig(Configuration source, Configuration target) {
        target.setNewBuiltinClassResolver(source.getNewBuiltinClassResolver());
        target.setTemplateUpdateDelayMilliseconds(source.getTemplateUpdateDelayMilliseconds());
        target.setDefaultEncoding(source.getDefaultEncoding());
        target.setLocale(source.getLocale());
        target.setBooleanFormat(source.getBooleanFormat());
        target.setDateTimeFormat(source.getDateTimeFormat());
        target.setDateFormat(source.getDateFormat());
        target.setTimeFormat(source.getTimeFormat());
        target.setNumberFormat(source.getNumberFormat());
        target.setOutputFormat(source.getOutputFormat());
        target.setURLEscapingCharset(source.getURLEscapingCharset());
        target.setLazyAutoImports(source.getLazyAutoImports());
        target.setTemplateExceptionHandler(source.getTemplateExceptionHandler());
    }

    @Override
    public void clear() {
        this.adminConfiguration.clearTemplateCache();
        this.clearTemplateCache();
    }

    public void clearTemplateCache() {
        this.webConfiguration.clearTemplateCache();
        this.taskConfiguration.clearTemplateCache();
    }

    public Configuration getWebConfiguration() {
        return this.webConfiguration;
    }

    public Configuration getTaskConfiguration() {
        return this.taskConfiguration;
    }

    public Configuration getAdminConfiguration() {
        return this.adminConfiguration;
    }

    public void setDirectivePrefix(String directivePrefix) {
        this.directivePrefix = directivePrefix;
    }
}

