/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.component.template;

import com.publiccms.common.base.Base;
import com.publiccms.common.tools.FreeMarkerUtils;
import java.io.File;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.publiccms.common.api.Cache;
import org.publiccms.common.base.AbstractFreemarkerView;
import org.publiccms.logic.component.site.SiteComponent;
import org.publiccms.logic.component.template.TemplateComponent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.ui.ModelMap;

@Component
public class TemplateCacheComponent
implements Cache,
Base {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static final String CACHE_VAR = "useCache";
    public static final String CONTENT_CACHE = "noCache";
    public static final String CACHE_FILE_DIRECTORY = "/cache";
    @Autowired
    private SiteComponent siteComponent;
    @Autowired
    private TemplateComponent templateComponent;

    public String getCachedPath(String requestPath, String fullTemplatePath, int cacheMillisTime, String acceptParamters, HttpServletRequest request, ModelMap modelMap) {
        ModelMap model = (ModelMap)modelMap.clone();
        AbstractFreemarkerView.exposeAttribute((Map<String, Object>)model, request.getScheme(), request.getServerName(), request.getServerPort(), request.getContextPath());
        model.put((Object)CACHE_VAR, (Object)true);
        return this.createCache(requestPath, fullTemplatePath, fullTemplatePath + TemplateCacheComponent.getRequestParamtersString(request, acceptParamters), cacheMillisTime, model);
    }

    private static String getRequestParamtersString(HttpServletRequest request, String acceptParamters) {
        StringBuilder sb = new StringBuilder();
        sb.append("/default.html");
        for (String paramterName : StringUtils.split((String)acceptParamters, (String)",")) {
            Object[] values = request.getParameterValues(paramterName);
            if (!ArrayUtils.isNotEmpty((Object[])values)) continue;
            for (int i = 0; i < values.length; ++i) {
                sb.append("_");
                sb.append(paramterName);
                sb.append("=");
                sb.append((String)values[i]);
            }
        }
        return sb.toString();
    }

    public void deleteCachedFile(String path) {
        FileUtils.deleteQuietly((File)new File(this.getCachedFilePath(path)));
    }

    @Override
    public void clear() {
        this.deleteCachedFile(this.getCachedFilePath(""));
    }

    private String createCache(String requestPath, String fullTemplatePath, String cachePath, int cacheMillisTime, ModelMap model) {
        String cachedFilePath = this.getCachedFilePath(cachePath);
        String cachedtemplatePath = CACHE_FILE_DIRECTORY + cachePath;
        String cachedPath = "globle:" + cachedtemplatePath;
        if (TemplateCacheComponent.checkCacheFile(cachedFilePath, cacheMillisTime)) {
            return cachedPath;
        }
        try {
            FreeMarkerUtils.generateFileByFile(fullTemplatePath, cachedFilePath, this.templateComponent.getWebConfiguration(), (Map<String, Object>)model);
            this.templateComponent.getWebConfiguration().removeTemplateFromCache(cachedtemplatePath);
            return cachedPath;
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            return requestPath;
        }
    }

    private static boolean checkCacheFile(String cacheFilePath, int millisTime) {
        File dest = new File(cacheFilePath);
        if (dest.exists()) {
            if (dest.lastModified() > System.currentTimeMillis() - (long)millisTime) {
                return true;
            }
            dest.setLastModified(System.currentTimeMillis());
        }
        return false;
    }

    private String getCachedFilePath(String path) {
        return this.siteComponent.getWebTemplateFilePath() + CACHE_FILE_DIRECTORY + path;
    }
}

