/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.component.template;

import com.fasterxml.jackson.core.type.TypeReference;
import com.publiccms.common.base.Base;
import com.publiccms.common.cache.CacheEntity;
import com.publiccms.common.cache.CacheEntityFactory;
import com.publiccms.common.tools.CommonUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.publiccms.common.api.SiteCache;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.site.SiteComponent;
import org.publiccms.views.pojo.CmsModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ModelComponent
implements SiteCache,
Base {
    private CacheEntity<Integer, Map<String, CmsModel>> modelCache;
    @Autowired
    private SiteComponent siteComponent;

    public List<CmsModel> getList(SysSite site, String parentId, Boolean hasChild, Boolean onlyUrl, Boolean hasImages, Boolean hasFiles) {
        ArrayList<CmsModel> modelList = new ArrayList<CmsModel>();
        Map<String, CmsModel> map = this.getMap(site);
        for (CmsModel model : map.values()) {
            if (!(CommonUtils.empty(parentId) && CommonUtils.empty(model.getParentId()) || CommonUtils.notEmpty(parentId) && parentId.equals(model.getParentId()) || CommonUtils.notEmpty(hasChild) && hasChild.equals(model.isHasChild()) || CommonUtils.notEmpty(onlyUrl) && onlyUrl.equals(model.isOnlyUrl()) || CommonUtils.notEmpty(hasImages) && hasImages.equals(model.isHasImages())) && (!CommonUtils.notEmpty(hasFiles) || !hasFiles.equals(model.isHasFiles()))) continue;
            modelList.add(model);
        }
        return modelList;
    }

    public Map<String, CmsModel> getMap(SysSite site) {
        Map modelMap = this.modelCache.get(site.getId());
        if (CommonUtils.empty(modelMap)) {
            File file = new File(this.siteComponent.getModelFilePath(site));
            if (CommonUtils.notEmpty(file)) {
                try {
                    modelMap = (Map)objectMapper.readValue(file, (TypeReference)new TypeReference<Map<String, CmsModel>>(){});
                }
                catch (IOException | ClassCastException e) {
                    modelMap = new HashMap<String, CmsModel>();
                }
            } else {
                modelMap = new HashMap<String, CmsModel>();
            }
            this.modelCache.put(site.getId(), modelMap);
        }
        return modelMap;
    }

    public boolean save(SysSite site, Map<String, CmsModel> modelMap) {
        File file = new File(this.siteComponent.getModelFilePath(site));
        if (CommonUtils.empty(file)) {
            file.getParentFile().mkdirs();
        }
        try {
            objectMapper.writeValue(file, modelMap);
            file.setReadable(true, false);
            file.setWritable(true, false);
        }
        catch (IOException e) {
            return false;
        }
        this.clear(site.getId());
        return true;
    }

    @Override
    public void clear() {
        this.modelCache.clear();
    }

    @Override
    public void clear(int siteId) {
        this.modelCache.remove(siteId);
    }

    @Autowired
    public void initCache(CacheEntityFactory cacheEntityFactory) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.modelCache = cacheEntityFactory.createCacheEntity("cmsModel");
    }
}

