/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.component.template;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.publiccms.common.base.Base;
import com.publiccms.common.cache.CacheEntity;
import com.publiccms.common.cache.CacheEntityFactory;
import com.publiccms.common.tools.CommonUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.publiccms.common.api.Cache;
import org.publiccms.views.pojo.CmsPageMetadata;
import org.publiccms.views.pojo.CmsPlaceMetadata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetadataComponent
implements Cache,
Base {
    public static final String METADATA_FILE = "metadata.data";
    private CacheEntity<String, Map<String, CmsPageMetadata>> pageCache;
    private CacheEntity<String, Map<String, CmsPlaceMetadata>> placeCache;

    public CmsPlaceMetadata getPlaceMetadata(String filePath) {
        File file = new File(filePath);
        CmsPlaceMetadata pageMetadata = this.getPlaceMetadataMap(file.getParent()).get(file.getName());
        if (null != pageMetadata) {
            return pageMetadata;
        }
        return new CmsPlaceMetadata();
    }

    public CmsPageMetadata getTemplateMetadata(String filePath) {
        return this.getTemplateMetadata(filePath, false);
    }

    public CmsPageMetadata getTemplateMetadata(String filePath, boolean allowNullValue) {
        File file = new File(filePath);
        CmsPageMetadata pageMetadata = this.getTemplateMetadataMap(file.getParent()).get(file.getName());
        if (null != pageMetadata) {
            return pageMetadata;
        }
        if (allowNullValue) {
            return null;
        }
        return new CmsPageMetadata();
    }

    public boolean updateTemplateMetadata(String filePath, CmsPageMetadata metadata) {
        File file = new File(filePath);
        String dirPath = file.getParent();
        Map<String, CmsPageMetadata> metadataMap = this.getTemplateMetadataMap(dirPath);
        metadataMap.put(file.getName(), metadata);
        try {
            this.saveTemplateMetadata(dirPath, metadataMap);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean updatePlaceMetadata(String filePath, CmsPlaceMetadata metadata) {
        File file = new File(filePath);
        String dirPath = file.getParent();
        Map<String, CmsPlaceMetadata> metadataMap = this.getPlaceMetadataMap(dirPath);
        metadataMap.put(file.getName(), metadata);
        try {
            this.savePlaceMetadata(dirPath, metadataMap);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean deleteTemplateMetadata(String filePath) {
        File file = new File(filePath);
        String dirPath = file.getParent();
        Map<String, CmsPageMetadata> metadataMap = this.getTemplateMetadataMap(dirPath);
        metadataMap.remove(file.getName());
        try {
            this.saveTemplateMetadata(dirPath, metadataMap);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean deletePlaceMetadata(String filePath) {
        File file = new File(filePath);
        String dirPath = file.getParent();
        Map<String, CmsPlaceMetadata> metadataMap = this.getPlaceMetadataMap(dirPath);
        metadataMap.remove(file.getName());
        try {
            this.savePlaceMetadata(dirPath, metadataMap);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public Map<String, CmsPlaceMetadata> getPlaceMetadataMap(String dirPath) {
        Map metadataMap = this.placeCache.get(dirPath);
        if (CommonUtils.empty(metadataMap)) {
            File file = new File(dirPath + "/" + METADATA_FILE);
            if (CommonUtils.notEmpty(file)) {
                try {
                    metadataMap = (Map)objectMapper.readValue(file, (TypeReference)new TypeReference<Map<String, CmsPlaceMetadata>>(){});
                }
                catch (IOException | ClassCastException e) {
                    metadataMap = new HashMap<String, CmsPlaceMetadata>();
                }
            } else {
                metadataMap = new HashMap<String, CmsPlaceMetadata>();
            }
            this.placeCache.put(dirPath, metadataMap);
        }
        return metadataMap;
    }

    public Map<String, CmsPageMetadata> getTemplateMetadataMap(String dirPath) {
        Map metadataMap = this.pageCache.get(dirPath);
        if (CommonUtils.empty(metadataMap)) {
            File file = new File(dirPath + "/" + METADATA_FILE);
            if (CommonUtils.notEmpty(file)) {
                try {
                    metadataMap = (Map)objectMapper.readValue(file, (TypeReference)new TypeReference<Map<String, CmsPageMetadata>>(){});
                }
                catch (IOException | ClassCastException e) {
                    metadataMap = new HashMap<String, CmsPageMetadata>();
                }
            } else {
                metadataMap = new HashMap<String, CmsPageMetadata>();
            }
            this.pageCache.put(dirPath, metadataMap);
        }
        return metadataMap;
    }

    private void saveTemplateMetadata(String dirPath, Map<String, CmsPageMetadata> metadataMap) throws JsonGenerationException, JsonMappingException, IOException {
        File file = new File(dirPath + "/" + METADATA_FILE);
        if (CommonUtils.empty(file)) {
            file.getParentFile().mkdirs();
        }
        objectMapper.writeValue(file, metadataMap);
        file.setReadable(true, false);
        file.setWritable(true, false);
        this.pageCache.clear();
    }

    private void savePlaceMetadata(String dirPath, Map<String, CmsPlaceMetadata> metadataMap) throws JsonGenerationException, JsonMappingException, IOException {
        File file = new File(dirPath + "/" + METADATA_FILE);
        if (CommonUtils.empty(file)) {
            file.getParentFile().mkdirs();
        }
        objectMapper.writeValue(file, metadataMap);
        file.setReadable(true, false);
        file.setWritable(true, false);
        this.placeCache.clear();
    }

    @Override
    public void clear() {
        this.placeCache.clear();
        this.pageCache.clear();
    }

    @Autowired
    public void initCache(CacheEntityFactory cacheEntityFactory) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.pageCache = cacheEntityFactory.createCacheEntity("pageMetadata");
        this.placeCache = cacheEntityFactory.createCacheEntity("placeMetadata");
    }
}

