/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.component.task;

import com.publiccms.common.tools.CommonUtils;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.publiccms.common.constants.CmsVersion;
import org.publiccms.logic.component.cache.CacheComponent;
import org.publiccms.logic.service.log.LogLoginService;
import org.publiccms.logic.service.log.LogOperateService;
import org.publiccms.logic.service.log.LogTaskService;
import org.publiccms.logic.service.sys.SysAppTokenService;
import org.publiccms.logic.service.sys.SysEmailTokenService;
import org.publiccms.logic.service.sys.SysUserTokenService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ScheduledTaskComponent {
    protected final Log log = LogFactory.getLog(this.getClass());
    @Autowired
    private SysAppTokenService appTokenService;
    @Autowired
    private SysEmailTokenService emailTokenService;
    @Autowired
    private SysUserTokenService userTokenService;
    @Autowired
    private LogLoginService logLoginService;
    @Autowired
    private LogOperateService logOperateService;
    @Autowired
    private LogTaskService logTaskService;
    @Autowired
    private CacheComponent cacheComponent;

    @Scheduled(fixedDelay=60000L)
    public void clearAppToken() {
        if (CmsVersion.isInitialized() && CmsVersion.isMaster()) {
            Date date = DateUtils.addMinutes((Date)CommonUtils.getDate(), (int)-30);
            this.appTokenService.delete(date);
            this.emailTokenService.delete(date);
        }
    }

    @Scheduled(cron="0 30 0/6 * * ?")
    public void clearCache() {
        if (CmsVersion.isInitialized()) {
            this.cacheComponent.clear();
            if (CmsVersion.isMaster()) {
                this.userTokenService.delete(DateUtils.addMonths((Date)CommonUtils.getDate(), (int)-3));
            }
        }
    }

    @Scheduled(cron="0 0 0 1 * ?")
    public void clearLog() {
        if (CmsVersion.isInitialized() && CmsVersion.isMaster()) {
            Date date = DateUtils.addYears((Date)CommonUtils.getDate(), (int)-2);
            this.logLoginService.delete(null, date);
            this.logOperateService.delete(null, date);
            this.logTaskService.delete(null, date);
        }
    }
}

