/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.component.task;

import com.publiccms.common.base.Base;
import com.publiccms.common.tools.CommonUtils;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.publiccms.entities.log.LogTask;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.entities.sys.SysTask;
import org.publiccms.logic.component.task.ScheduledJob;
import org.publiccms.logic.component.template.TemplateComponent;
import org.publiccms.logic.service.log.LogTaskService;
import org.publiccms.logic.service.sys.SysSiteService;
import org.publiccms.logic.service.sys.SysTaskService;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ScheduledTask
implements Base {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static final String ID = "id";
    public static final int TASK_STATUS_READY = 0;
    public static final int TASK_STATUS_RUNNING = 1;
    public static final int TASK_STATUS_PAUSE = 2;
    public static final int TASK_STATUS_ERROR = 3;
    @Autowired
    private SysTaskService sysTaskService;
    @Autowired(required=false)
    private Scheduler scheduler;
    @Autowired
    private LogTaskService logTaskService;
    @Autowired
    private SysSiteService siteService;
    @Autowired
    private TemplateComponent templateComponent;

    public void init(Date startDate) {
        if (null != this.scheduler) {
            List<?> sysTaskList = this.sysTaskService.getPage(null, null, startDate, null, null).getList();
            for (SysTask sysTask : sysTaskList) {
                SysSite site = (SysSite)this.siteService.getEntity(Integer.valueOf(sysTask.getSiteId()));
                if (3 == sysTask.getStatus()) {
                    this.sysTaskService.updateStatus(sysTask.getId(), 0);
                }
                this.create(site, sysTask.getId(), sysTask.getCronExpression());
                if (2 != sysTask.getStatus()) continue;
                this.pause(site, sysTask.getId());
            }
            ScheduledJob.setSysTaskService(this.sysTaskService);
            ScheduledJob.setLogTaskService(this.logTaskService);
            ScheduledJob.setSiteService(this.siteService);
            ScheduledJob.setScheduledTask(this);
            ScheduledJob.setTemplateComponent(this.templateComponent);
        }
    }

    public void create(SysSite site, Integer id, String cronExpression) {
        if (CommonUtils.notEmpty(id) && CommonUtils.notEmpty(cronExpression)) {
            Date startTime = CommonUtils.getDate();
            String taskName = this.getTaskName(id);
            TriggerKey triggerKey = TriggerKey.triggerKey((String)taskName);
            try {
                CronTrigger trigger = (CronTrigger)this.scheduler.getTrigger(triggerKey);
                CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)(site.getId() % 60 + " " + cronExpression));
                if (null == trigger) {
                    JobDetail jobDetail = JobBuilder.newJob(ScheduledJob.class).withIdentity(taskName).build();
                    jobDetail.getJobDataMap().put(ID, (Object)id);
                    trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).startNow().build();
                    this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
                } else {
                    trigger = (CronTrigger)trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).startNow().build();
                    this.scheduler.rescheduleJob(triggerKey, (Trigger)trigger);
                }
            }
            catch (SchedulerException e) {
                this.sysTaskService.updateStatus(id, 3);
                this.logTaskService.save(new LogTask(site.getId(), (int)id, startTime, CommonUtils.getDate(), false, e.getMessage()));
            }
        }
    }

    public void runOnce(SysSite site, Integer id) {
        if (CommonUtils.notEmpty(id)) {
            Date startTime = CommonUtils.getDate();
            try {
                this.scheduler.triggerJob(JobKey.jobKey((String)this.getTaskName(id)));
            }
            catch (SchedulerException e) {
                this.sysTaskService.updateStatus(id, 3);
                this.logTaskService.save(new LogTask(site.getId(), (int)id, startTime, CommonUtils.getDate(), false, e.getMessage()));
            }
        }
    }

    public void pause(SysSite site, Integer id) {
        if (CommonUtils.notEmpty(id)) {
            Date startTime = CommonUtils.getDate();
            try {
                this.scheduler.pauseJob(JobKey.jobKey((String)this.getTaskName(id)));
            }
            catch (SchedulerException e) {
                this.sysTaskService.updateStatus(id, 3);
                this.logTaskService.save(new LogTask(site.getId(), (int)id, startTime, CommonUtils.getDate(), false, e.getMessage()));
            }
        }
    }

    public void resume(SysSite site, Integer id) {
        if (CommonUtils.notEmpty(id)) {
            Date startTime = CommonUtils.getDate();
            try {
                this.scheduler.resumeJob(JobKey.jobKey((String)this.getTaskName(id)));
            }
            catch (SchedulerException e) {
                this.sysTaskService.updateStatus(id, 3);
                this.logTaskService.save(new LogTask(site.getId(), (int)id, startTime, CommonUtils.getDate(), false, e.getMessage()));
            }
        }
    }

    public void delete(Integer id) {
        if (CommonUtils.notEmpty(id)) {
            try {
                this.scheduler.deleteJob(JobKey.jobKey((String)this.getTaskName(id)));
            }
            catch (SchedulerException e) {
                this.log.error((Object)e.getMessage());
            }
        }
    }

    public String getTaskName(Integer id) {
        return "task-" + id;
    }
}

