/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.component.task;

import com.publiccms.common.tools.FreeMarkerUtils;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import org.publiccms.common.base.AbstractFreemarkerView;
import org.publiccms.entities.log.LogTask;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.entities.sys.SysTask;
import org.publiccms.logic.component.site.SiteComponent;
import org.publiccms.logic.component.task.ScheduledTask;
import org.publiccms.logic.component.template.TemplateComponent;
import org.publiccms.logic.service.log.LogTaskService;
import org.publiccms.logic.service.sys.SysSiteService;
import org.publiccms.logic.service.sys.SysTaskService;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class ScheduledJob
extends QuartzJobBean {
    private static String[] ignoreProperties = new String[]{"id", "begintime", "taskId", "siteId"};
    private static SysTaskService sysTaskService;
    private static LogTaskService logTaskService;
    private static SysSiteService siteService;
    private static ScheduledTask scheduledTask;
    private static TemplateComponent templateComponent;

    public void executeInternal(JobExecutionContext context) throws JobExecutionException {
        Integer taskId = (Integer)context.getJobDetail().getJobDataMap().get((Object)"id");
        SysTask task = (SysTask)sysTaskService.getEntity(taskId);
        if (null != task) {
            if (0 == task.getStatus() && sysTaskService.updateStatusToRunning(task.getId())) {
                String result;
                LogTask entity = new LogTask(task.getSiteId(), task.getId(), new Date(), false);
                logTaskService.save(entity);
                boolean success = false;
                try {
                    success = true;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("task", task);
                    SysSite site = (SysSite)siteService.getEntity(Integer.valueOf(task.getSiteId()));
                    AbstractFreemarkerView.exposeSite(map, site);
                    result = FreeMarkerUtils.generateStringByFile(SiteComponent.getFullFileName(site, task.getFilePath()), templateComponent.getTaskConfiguration(), map);
                }
                catch (TemplateException | IOException e) {
                    result = e.getMessage();
                }
                entity.setEndtime(new Date());
                entity.setSuccess(success);
                entity.setResult(result);
                logTaskService.update(entity.getId(), entity, ignoreProperties);
                sysTaskService.updateStatus(task.getId(), 0);
            }
        } else {
            scheduledTask.delete(taskId);
        }
    }

    public static void setSysTaskService(SysTaskService sysTaskService) {
        ScheduledJob.sysTaskService = sysTaskService;
    }

    public static void setLogTaskService(LogTaskService logTaskService) {
        ScheduledJob.logTaskService = logTaskService;
    }

    public static void setSiteService(SysSiteService siteService) {
        ScheduledJob.siteService = siteService;
    }

    public static void setScheduledTask(ScheduledTask scheduledTask) {
        ScheduledJob.scheduledTask = scheduledTask;
    }

    public static void setTemplateComponent(TemplateComponent templateComponent) {
        ScheduledJob.templateComponent = templateComponent;
    }
}

