/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.component.site;

import com.publiccms.common.cache.CacheEntity;
import com.publiccms.common.cache.CacheEntityFactory;
import com.publiccms.common.tools.CommonUtils;
import java.util.List;
import org.publiccms.common.api.Cache;
import org.publiccms.entities.cms.CmsContent;
import org.publiccms.entities.cms.CmsContentRelated;
import org.publiccms.entities.cms.CmsPlace;
import org.publiccms.entities.cms.CmsTag;
import org.publiccms.entities.cms.CmsWord;
import org.publiccms.logic.service.cms.CmsContentRelatedService;
import org.publiccms.logic.service.cms.CmsContentService;
import org.publiccms.logic.service.cms.CmsPlaceService;
import org.publiccms.logic.service.cms.CmsTagService;
import org.publiccms.logic.service.cms.CmsWordService;
import org.publiccms.views.pojo.CmsContentRelatedStatistics;
import org.publiccms.views.pojo.CmsContentStatistics;
import org.publiccms.views.pojo.CmsPlaceStatistics;
import org.publiccms.views.pojo.CmsTagStatistics;
import org.publiccms.views.pojo.CmsWordStatistics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StatisticsComponent
implements Cache {
    private CacheEntity<Long, CmsContentStatistics> contentCache;
    private CacheEntity<Long, CmsPlaceStatistics> placeCache;
    private CacheEntity<Long, CmsContentRelatedStatistics> relatedCache;
    private CacheEntity<Long, CmsWordStatistics> wordCache;
    private CacheEntity<Long, CmsTagStatistics> tagCache;
    @Autowired
    private CmsContentService contentService;
    @Autowired
    private CmsContentRelatedService contentRelatedService;
    @Autowired
    private CmsPlaceService placeService;
    @Autowired
    private CmsWordService wordService;
    @Autowired
    private CmsTagService tagService;

    public CmsContentRelatedStatistics relatedClicks(Long id) {
        if (CommonUtils.notEmpty(id)) {
            CmsContentRelatedStatistics contentRelatedStatistics = this.relatedCache.get(id);
            if (null == contentRelatedStatistics) {
                contentRelatedStatistics = new CmsContentRelatedStatistics(id, 1, (CmsContentRelated)this.contentRelatedService.getEntity(id));
            } else {
                contentRelatedStatistics.setClicks(contentRelatedStatistics.getClicks() + 1);
            }
            List<CmsContentRelatedStatistics> list = this.relatedCache.put(id, contentRelatedStatistics);
            if (CommonUtils.notEmpty(list)) {
                this.contentRelatedService.updateStatistics(list);
            }
            return contentRelatedStatistics;
        }
        return null;
    }

    public CmsTagStatistics searchTag(Long id) {
        if (CommonUtils.notEmpty(id)) {
            CmsTagStatistics tagStatistics = this.tagCache.get(id);
            if (null == tagStatistics) {
                tagStatistics = new CmsTagStatistics(id, 1, (CmsTag)this.tagService.getEntity(id));
            } else {
                tagStatistics.setSearchCounts(tagStatistics.getSearchCounts() + 1);
            }
            List<CmsTagStatistics> list = this.tagCache.put(id, tagStatistics);
            if (CommonUtils.notEmpty(list)) {
                this.tagService.updateStatistics(list);
            }
            return tagStatistics;
        }
        return null;
    }

    public CmsWordStatistics search(int siteId, String word) {
        if (CommonUtils.notEmpty(word)) {
            CmsWordStatistics wordStatistics;
            CmsWord entity = this.wordService.getEntity(siteId, word);
            if (null == entity) {
                entity = new CmsWord();
                entity.setName(word);
                entity.setSiteId(siteId);
                entity.setHidden(true);
                this.wordService.save(entity);
            }
            if (null == (wordStatistics = this.wordCache.get(entity.getId()))) {
                wordStatistics = new CmsWordStatistics(entity.getId(), 1, entity);
            } else {
                wordStatistics.setSearchCounts(wordStatistics.getSearchCounts() + 1);
            }
            List<CmsWordStatistics> list = this.wordCache.put(entity.getId(), wordStatistics);
            if (CommonUtils.notEmpty(list)) {
                this.wordService.updateStatistics(list);
            }
            return wordStatistics;
        }
        return null;
    }

    public CmsPlaceStatistics placeClicks(Long id) {
        if (CommonUtils.notEmpty(id)) {
            CmsPlaceStatistics placeStatistics = this.placeCache.get(id);
            if (null == placeStatistics) {
                placeStatistics = new CmsPlaceStatistics(id, 1, (CmsPlace)this.placeService.getEntity(id));
            } else {
                placeStatistics.setClicks(placeStatistics.getClicks() + 1);
            }
            List<CmsPlaceStatistics> list = this.placeCache.put(id, placeStatistics);
            if (CommonUtils.notEmpty(list)) {
                this.placeService.updateStatistics(list);
            }
            return placeStatistics;
        }
        return null;
    }

    public CmsContentStatistics clicks(Long id) {
        if (CommonUtils.notEmpty(id)) {
            CmsContentStatistics contentStatistics = this.contentCache.get(id);
            if (null == contentStatistics) {
                contentStatistics = new CmsContentStatistics(id, 1, 0, 0, (CmsContent)this.contentService.getEntity(id));
            } else {
                contentStatistics.setClicks(contentStatistics.getClicks() + 1);
            }
            List<CmsContentStatistics> list = this.contentCache.put(id, contentStatistics);
            if (CommonUtils.notEmpty(list)) {
                this.contentService.updateStatistics(list);
            }
            return contentStatistics;
        }
        return null;
    }

    @Override
    public void clear() {
        this.placeService.updateStatistics(this.placeCache.clear());
        this.contentRelatedService.updateStatistics(this.relatedCache.clear());
        this.wordService.updateStatistics(this.wordCache.clear());
        this.tagService.updateStatistics(this.tagCache.clear());
        this.contentService.updateStatistics(this.contentCache.clear());
    }

    @Autowired
    public void initCache(CacheEntityFactory cacheEntityFactory) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.contentCache = cacheEntityFactory.createCacheEntity("content");
        this.placeCache = cacheEntityFactory.createCacheEntity("place");
        this.relatedCache = cacheEntityFactory.createCacheEntity("related");
        this.wordCache = cacheEntityFactory.createCacheEntity("word");
        this.tagCache = cacheEntityFactory.createCacheEntity("tag");
    }
}

