/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.component.site;

import com.publiccms.common.base.Base;
import com.publiccms.common.cache.CacheEntity;
import com.publiccms.common.cache.CacheEntityFactory;
import com.publiccms.common.tools.CommonUtils;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.publiccms.common.api.Cache;
import org.publiccms.entities.sys.SysDomain;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.service.sys.SysDomainService;
import org.publiccms.logic.service.sys.SysSiteService;
import org.springframework.beans.factory.annotation.Autowired;

public class SiteComponent
implements Cache,
Base {
    public static final String TEMPLATE_PATH = "template";
    public static final String TASK_FILE_PATH = "task";
    public static final String STATIC_FILE_PATH_WEB = "web";
    public static final String SITE_PATH_PREFIX = "/site_";
    public static final String MODEL_FILE = "model.data";
    public static final String CONFIG_FILE = "config.data";
    private CacheEntity<String, SysSite> siteCache;
    private CacheEntity<String, SysDomain> domainCache;
    private String rootPath;
    private String webFilePath;
    private String taskTemplateFilePath;
    private String webTemplateFilePath;
    private int defaultSiteId;
    private Set<Integer> idSet = new HashSet<Integer>();
    @Autowired
    private SysDomainService sysDomainService;
    @Autowired
    private SysSiteService sysSiteService;

    public static String getFullFileName(SysSite site, String path) {
        if (path.contains("..")) {
            path = path.replace("..", "");
        }
        if (path.startsWith("/") || path.startsWith("\\")) {
            return SITE_PATH_PREFIX + site.getId() + path;
        }
        return SITE_PATH_PREFIX + site.getId() + "/" + path;
    }

    public String getViewNamePreffix(String serverName) {
        SysDomain sysDomain = this.getDomain(serverName);
        SysSite site = this.getSite(serverName);
        return this.getViewNamePreffix(site, sysDomain);
    }

    public String getViewNamePreffix(SysSite site, SysDomain sysDomain) {
        return SiteComponent.getFullFileName(site, CommonUtils.empty(sysDomain.getPath()) ? "" : sysDomain.getPath() + "/");
    }

    public SysDomain getDomain(String serverName) {
        SysDomain sysDomain = this.domainCache.get(serverName);
        if (null == sysDomain) {
            sysDomain = (SysDomain)this.sysDomainService.getEntity((Serializable)((Object)serverName));
            if (null == sysDomain) {
                int index;
                if (null != serverName && 0 < (index = serverName.indexOf(".")) && index != serverName.lastIndexOf(".")) {
                    sysDomain = this.getDomain(serverName.substring(index + 1));
                    if (null != sysDomain.getName() && !sysDomain.isWild()) {
                        sysDomain = new SysDomain();
                        sysDomain.setSiteId(this.defaultSiteId);
                    }
                } else {
                    sysDomain = new SysDomain();
                    sysDomain.setSiteId(this.defaultSiteId);
                }
            } else {
                this.domainCache.put(serverName, sysDomain);
            }
        }
        return sysDomain;
    }

    public SysSite getSite(String serverName) {
        SysSite site = this.siteCache.get(serverName);
        if (null == site) {
            site = (SysSite)this.sysSiteService.getEntity(Integer.valueOf(this.getDomain(serverName).getSiteId()));
            this.siteCache.put(serverName, site);
        }
        return site;
    }

    public boolean isMaster(int siteId) {
        return null != this.idSet && this.idSet.contains(siteId);
    }

    public String getWebFilePath(SysSite site, String filePath) {
        return this.webFilePath + SiteComponent.getFullFileName(site, filePath);
    }

    public String getTaskTemplateFilePath(SysSite site, String templatePath) {
        return this.getTaskTemplateFilePath() + SiteComponent.getFullFileName(site, templatePath);
    }

    public String getWebTemplateFilePath(SysSite site, String templatePath) {
        return this.getWebTemplateFilePath() + SiteComponent.getFullFileName(site, templatePath);
    }

    public String getModelFilePath(SysSite site) {
        return this.getWebTemplateFilePath() + SiteComponent.getFullFileName(site, MODEL_FILE);
    }

    public String getConfigFilePath(SysSite site) {
        return this.getWebTemplateFilePath() + SiteComponent.getFullFileName(site, CONFIG_FILE);
    }

    public void setDefaultSiteId(int defaultSiteId) {
        this.defaultSiteId = defaultSiteId;
    }

    public void setSiteMasters(String siteMasters) {
        String[] masters;
        for (String master : masters = StringUtils.split((String)siteMasters, (String)",")) {
            Integer id;
            try {
                id = Integer.parseInt(master);
            }
            catch (NumberFormatException e) {
                id = null;
            }
            if (!CommonUtils.notEmpty(id)) continue;
            this.idSet.add(id);
        }
    }

    public void setRootPath(String rootPath) {
        if (CommonUtils.notEmpty(rootPath) && !rootPath.endsWith("/") && !rootPath.endsWith("\\")) {
            rootPath = rootPath + "/";
        }
        this.rootPath = rootPath;
        this.webFilePath = rootPath + STATIC_FILE_PATH_WEB;
        this.taskTemplateFilePath = rootPath + TASK_FILE_PATH;
        this.webTemplateFilePath = rootPath + TEMPLATE_PATH;
    }

    @Override
    public void clear() {
        this.siteCache.clear();
        this.domainCache.clear();
    }

    @Autowired
    public void initCache(CacheEntityFactory cacheEntityFactory) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.domainCache = cacheEntityFactory.createCacheEntity("domain");
        this.siteCache = cacheEntityFactory.createCacheEntity("site");
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setTaskTemplateFilePath(String taskTemplateFilePath) {
        this.taskTemplateFilePath = taskTemplateFilePath;
    }

    public void setWebTemplateFilePath(String webTemplateFilePath) {
        this.webTemplateFilePath = webTemplateFilePath;
    }

    public String getTaskTemplateFilePath() {
        return this.taskTemplateFilePath;
    }

    public String getWebTemplateFilePath() {
        return this.webTemplateFilePath;
    }
}

