/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.component.site;

import com.publiccms.common.base.Base;
import com.publiccms.common.tools.CommonUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.publiccms.logic.component.template.TemplateComponent;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FileComponent
implements Base {
    private DateFormat dateFormat = new SimpleDateFormat("yyyy/MM-dd/HH-mm-ssSSSS");

    public List<FileInfo> getFileList(String dirPath) {
        ArrayList<FileInfo> fileList = new ArrayList<FileInfo>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(dirPath, new String[0]));){
            ArrayList<FileInfo> tempList = new ArrayList<FileInfo>();
            for (Path entry : stream) {
                String fileName;
                Path fileNamePath = entry.getFileName();
                if (null == fileNamePath || (fileName = fileNamePath.toString()).endsWith(".data") || TemplateComponent.INCLUDE_DIRECTORY.equalsIgnoreCase(fileName)) continue;
                BasicFileAttributes attrs = Files.readAttributes(entry, BasicFileAttributes.class, new LinkOption[0]);
                if (attrs.isDirectory()) {
                    fileList.add(new FileInfo(fileName, true, attrs));
                    continue;
                }
                tempList.add(new FileInfo(fileName, false, attrs));
            }
            fileList.addAll(tempList);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileList;
    }

    public boolean createFile(File file, String content) throws IOException {
        if (CommonUtils.empty(file)) {
            FileUtils.writeStringToFile((File)file, (String)content, (Charset)DEFAULT_CHARSET);
            file.setReadable(true, false);
            file.setWritable(true, false);
            return true;
        }
        return false;
    }

    public boolean deleteFile(String filePath) {
        File file = new File(filePath);
        if (CommonUtils.notEmpty(file)) {
            FileUtils.deleteQuietly((File)file);
            return true;
        }
        return false;
    }

    public boolean updateFile(File file, String content) throws IOException {
        if (CommonUtils.notEmpty(file)) {
            FileUtils.writeStringToFile((File)file, (String)content, (Charset)DEFAULT_CHARSET);
            return true;
        }
        return false;
    }

    public String getFileContent(String filePath) {
        try {
            return FileUtils.readFileToString((File)new File(filePath), (Charset)DEFAULT_CHARSET);
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUploadFileName(String suffix) {
        StringBuilder sb = new StringBuilder("upload/");
        DateFormat dateFormat = this.dateFormat;
        synchronized (dateFormat) {
            sb.append(this.dateFormat.format(CommonUtils.getDate()));
        }
        return sb.append(r.nextInt()).append(suffix).toString();
    }

    public String getSuffix(String originalFilename) {
        return originalFilename.substring(originalFilename.lastIndexOf("."), originalFilename.length());
    }

    public String upload(MultipartFile file, String fileName) throws IllegalStateException, IOException {
        File dest = new File(fileName);
        dest.getParentFile().mkdirs();
        file.transferTo(dest);
        dest.setReadable(true, false);
        dest.setWritable(true, false);
        return dest.getName();
    }

    public class FileInfo {
        private String fileName;
        private boolean directory;
        private Date lastModifiedTime;
        private Date lastAccessTime;
        private Date creationTime;
        private long size;

        public FileInfo(String fileName, boolean directory, BasicFileAttributes attrs) {
            this.fileName = fileName;
            this.directory = directory;
            this.lastModifiedTime = new Date(attrs.lastModifiedTime().toMillis());
            this.lastAccessTime = new Date(attrs.lastAccessTime().toMillis());
            this.creationTime = new Date(attrs.creationTime().toMillis());
            this.size = attrs.size();
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public Date getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public void setLastModifiedTime(Date lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public Date getLastAccessTime() {
            return this.lastAccessTime;
        }

        public void setLastAccessTime(Date lastAccessTime) {
            this.lastAccessTime = lastAccessTime;
        }

        public Date getCreationTime() {
            return this.creationTime;
        }

        public void setCreationTime(Date creationTime) {
            this.creationTime = creationTime;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public boolean isDirectory() {
            return this.directory;
        }

        public void setDirectory(boolean directory) {
            this.directory = directory;
        }
    }
}

