/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.component.site;

import com.publiccms.common.base.Base;
import com.publiccms.common.cache.CacheEntity;
import com.publiccms.common.cache.CacheEntityFactory;
import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.LanguagesUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.publiccms.common.api.Config;
import org.publiccms.common.api.SiteCache;
import org.publiccms.common.constants.CommonConstants;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.config.ConfigComponent;
import org.publiccms.logic.component.site.SendTask;
import org.publiccms.views.pojo.ExtendField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

@Component
public class EmailComponent
implements SiteCache,
Config,
Base {
    public static final String CONFIG_CODE = "email";
    public static final String CONFIG_EMAIL_SMTP_DEFAULTENCODING = "defaultEncoding";
    public static final String CONFIG_EMAIL_SMTP_HOST = "host";
    public static final String CONFIG_EMAIL_SMTP_PORT = "port";
    public static final String CONFIG_EMAIL_SMTP_USERNAME = "username";
    public static final String CONFIG_EMAIL_SMTP_PASSWORD = "password";
    public static final String CONFIG_EMAIL_SMTP_TIMEOUT = "timeout";
    public static final String CONFIG_EMAIL_SMTP_AUTH = "auth";
    public static final String CONFIG_EMAIL_SMTP_FROMADDRESS = "fromAddress";
    public static final String CONFIG_CODE_DESCRIPTION = "config.email";
    @Autowired
    private ConfigComponent configComponent;
    private CacheEntity<Integer, JavaMailSenderImpl> cache;
    private static ExecutorService pool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());

    public JavaMailSender getMailSender(int siteId, Map<String, String> config) {
        JavaMailSenderImpl javaMailSender = this.cache.get(siteId);
        if (null == javaMailSender) {
            javaMailSender = new JavaMailSenderImpl();
            javaMailSender.setDefaultEncoding(config.get(CONFIG_EMAIL_SMTP_DEFAULTENCODING));
            javaMailSender.setHost(config.get(CONFIG_EMAIL_SMTP_HOST));
            javaMailSender.setPort(Integer.parseInt(config.get(CONFIG_EMAIL_SMTP_PORT)));
            javaMailSender.setUsername(config.get(CONFIG_EMAIL_SMTP_USERNAME));
            javaMailSender.setPassword(config.get(CONFIG_EMAIL_SMTP_PASSWORD));
            Properties properties = new Properties();
            properties.setProperty("mail.smtp.auth", config.get(CONFIG_EMAIL_SMTP_AUTH));
            properties.setProperty("mail.smtp.timeout", config.get(CONFIG_EMAIL_SMTP_TIMEOUT));
            javaMailSender.setJavaMailProperties(properties);
            this.cache.put(siteId, javaMailSender);
        }
        return javaMailSender;
    }

    public boolean send(int siteId, String toAddress, String title, String content) throws MessagingException {
        return this.send(siteId, toAddress, title, content, false);
    }

    public boolean sendHtml(int siteId, String toAddress, String title, String html) throws MessagingException {
        return this.send(siteId, toAddress, title, html, true);
    }

    private boolean send(int siteId, String toAddress, String title, String content, boolean isHtml) throws MessagingException {
        Map<String, String> config = this.configComponent.getConfigData(siteId, CONFIG_CODE);
        if (CommonUtils.notEmpty(config) && CommonUtils.notEmpty(config.get(CONFIG_EMAIL_SMTP_FROMADDRESS))) {
            JavaMailSender mailSender = this.getMailSender(siteId, config);
            MimeMessage message = mailSender.createMimeMessage();
            MimeMessageHelper messageHelper = new MimeMessageHelper(message, false, "UTF-8");
            messageHelper.setTo(toAddress);
            messageHelper.setFrom(config.get(CONFIG_EMAIL_SMTP_FROMADDRESS));
            messageHelper.setSubject(title);
            messageHelper.setText(content, isHtml);
            pool.execute(new SendTask(mailSender, message));
            return true;
        }
        return false;
    }

    @Override
    public String getCode(SysSite site) {
        return CONFIG_CODE;
    }

    @Override
    public String getCodeDescription(SysSite site, Locale locale) {
        return LanguagesUtils.getMessage(CommonConstants.webApplicationContext, locale, CONFIG_CODE_DESCRIPTION, new Object[0]);
    }

    @Override
    public List<ExtendField> getExtendFieldList(SysSite site, Locale locale) {
        ArrayList<ExtendField> extendFieldList = new ArrayList<ExtendField>();
        extendFieldList.add(new ExtendField(CONFIG_EMAIL_SMTP_DEFAULTENCODING, "text", true, LanguagesUtils.getMessage(CommonConstants.webApplicationContext, locale, "config.email.defaultEncoding", new Object[0]), null, "UTF-8"));
        extendFieldList.add(new ExtendField(CONFIG_EMAIL_SMTP_HOST, "text", true, LanguagesUtils.getMessage(CommonConstants.webApplicationContext, locale, "config.email.host", new Object[0]), null, null));
        extendFieldList.add(new ExtendField(CONFIG_EMAIL_SMTP_PORT, "number", true, LanguagesUtils.getMessage(CommonConstants.webApplicationContext, locale, "config.email.port", new Object[0]), null, String.valueOf(25)));
        extendFieldList.add(new ExtendField(CONFIG_EMAIL_SMTP_USERNAME, "text", true, LanguagesUtils.getMessage(CommonConstants.webApplicationContext, locale, "config.email.username", new Object[0]), null, null));
        extendFieldList.add(new ExtendField(CONFIG_EMAIL_SMTP_PASSWORD, CONFIG_EMAIL_SMTP_PASSWORD, true, LanguagesUtils.getMessage(CommonConstants.webApplicationContext, locale, "config.email.password", new Object[0]), null, null));
        extendFieldList.add(new ExtendField(CONFIG_EMAIL_SMTP_TIMEOUT, "number", true, LanguagesUtils.getMessage(CommonConstants.webApplicationContext, locale, "config.email.timeout", new Object[0]), null, String.valueOf(3000)));
        extendFieldList.add(new ExtendField(CONFIG_EMAIL_SMTP_AUTH, "boolean", true, LanguagesUtils.getMessage(CommonConstants.webApplicationContext, locale, "config.email.auth", new Object[0]), null, null));
        extendFieldList.add(new ExtendField(CONFIG_EMAIL_SMTP_FROMADDRESS, CONFIG_CODE, true, LanguagesUtils.getMessage(CommonConstants.webApplicationContext, locale, "config.email.fromAddress", new Object[0]), null, null));
        return extendFieldList;
    }

    @Override
    public void clear(int siteId) {
        this.cache.remove(siteId);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Autowired
    public void initCache(CacheEntityFactory cacheEntityFactory) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.cache = cacheEntityFactory.createCacheEntity(CONFIG_CODE, "memory");
    }
}

