/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.component.site;

import com.publiccms.common.base.Base;
import com.publiccms.common.base.BaseMethod;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.publiccms.common.base.AbstractAppDirective;
import org.publiccms.common.base.AbstractTaskDirective;
import org.publiccms.common.base.AbstractTemplateDirective;
import org.springframework.beans.factory.annotation.Autowired;

public class DirectiveComponent
implements Base {
    private String directiveRemoveRegex;
    private String methodRemoveRegex;
    protected final Log log = LogFactory.getLog(this.getClass());
    private Map<String, AbstractTemplateDirective> templateDirectiveMap = new HashMap<String, AbstractTemplateDirective>();
    private Map<String, AbstractTaskDirective> taskDirectiveMap = new HashMap<String, AbstractTaskDirective>();
    private Map<String, AbstractAppDirective> appDirectiveMap = new HashMap<String, AbstractAppDirective>();
    private Map<String, BaseMethod> methodMap = new HashMap<String, BaseMethod>();

    @Autowired
    private void init(List<AbstractTemplateDirective> templateDirectiveList, List<AbstractTaskDirective> taskDirectiveList, List<AbstractAppDirective> appDirectiveList, List<BaseMethod> methodList) {
        for (AbstractTemplateDirective abstractTemplateDirective : templateDirectiveList) {
            if (null == abstractTemplateDirective.getName()) {
                abstractTemplateDirective.setName(StringUtils.uncapitalize((String)abstractTemplateDirective.getClass().getSimpleName().replaceAll(this.directiveRemoveRegex, "")));
            }
            this.templateDirectiveMap.put(abstractTemplateDirective.getName(), abstractTemplateDirective);
        }
        this.log.info((Object)(this.templateDirectiveMap.size() + " template directives created:" + this.templateDirectiveMap.keySet()));
        for (AbstractTaskDirective abstractTaskDirective : taskDirectiveList) {
            if (null == abstractTaskDirective.getName()) {
                abstractTaskDirective.setName(StringUtils.uncapitalize((String)abstractTaskDirective.getClass().getSimpleName().replaceAll(this.directiveRemoveRegex, "")));
            }
            this.taskDirectiveMap.put(abstractTaskDirective.getName(), abstractTaskDirective);
        }
        this.log.info((Object)(this.taskDirectiveMap.size() + " task directives created:" + this.taskDirectiveMap.keySet()));
        for (AbstractAppDirective abstractAppDirective : appDirectiveList) {
            if (null == abstractAppDirective.getName()) {
                abstractAppDirective.setName(StringUtils.uncapitalize((String)abstractAppDirective.getClass().getSimpleName().replaceAll(this.directiveRemoveRegex, "")));
            }
            this.appDirectiveMap.put(abstractAppDirective.getName(), abstractAppDirective);
        }
        this.log.info((Object)(this.appDirectiveMap.size() + " app directives created:" + this.appDirectiveMap.keySet()));
        for (BaseMethod baseMethod : methodList) {
            if (null == baseMethod.getName()) {
                baseMethod.setName(StringUtils.uncapitalize((String)baseMethod.getClass().getSimpleName().replaceAll(this.methodRemoveRegex, "")));
            }
            this.methodMap.put(baseMethod.getName(), baseMethod);
        }
        this.log.info((Object)(this.methodMap.size() + " methods created:" + this.methodMap.keySet()));
    }

    public void setDirectiveRemoveRegex(String directiveRemoveRegex) {
        this.directiveRemoveRegex = directiveRemoveRegex;
    }

    public void setMethodRemoveRegex(String methodRemoveRegex) {
        this.methodRemoveRegex = methodRemoveRegex;
    }

    public Map<String, AbstractTemplateDirective> getTemplateDirectiveMap() {
        return this.templateDirectiveMap;
    }

    public Map<String, AbstractAppDirective> getAppDirectiveMap() {
        return this.appDirectiveMap;
    }

    public Map<String, AbstractTaskDirective> getTaskDirectiveMap() {
        return this.taskDirectiveMap;
    }

    public Map<String, BaseMethod> getMethodMap() {
        return this.methodMap;
    }
}

