/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.component.site;

import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.tools.CommonUtils;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.PreDestroy;
import org.publiccms.common.constants.CmsVersion;
import org.publiccms.entities.sys.SysCluster;
import org.publiccms.logic.component.task.ScheduledTask;
import org.publiccms.logic.service.sys.SysClusterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ClusterComponent {
    public static final long THEARTBEAT_INTERVAL = 60000L;
    @Autowired
    private SysClusterService service;
    @Autowired
    private ScheduledTask scheduledTask;

    private void upgrade() {
        CmsVersion.setMaster(true);
        this.service.updateMaster((Serializable)((Object)CmsVersion.getClusterId()), true);
    }

    @Scheduled(fixedDelay=60000L)
    public void heartbeat() {
        if (CmsVersion.isInitialized()) {
            SysCluster entity = (SysCluster)this.service.getEntity((Serializable)((Object)CmsVersion.getClusterId()));
            Date now = CommonUtils.getDate();
            Date lastHeartbeatDate = null;
            if (null == entity) {
                entity = new SysCluster(CmsVersion.getClusterId(), now, now, false, CmsVersion.getVersion());
                this.service.save(entity);
            } else {
                lastHeartbeatDate = entity.getHeartbeatDate();
            }
            this.service.updateHeartbeatDate((Serializable)((Object)CmsVersion.getClusterId()), now);
            if (CmsVersion.isMaster() != entity.isMaster()) {
                CmsVersion.setMaster(entity.isMaster());
            }
            Date acceptTeartbeatDate = new Date(now.getTime() - 120000L);
            if (entity.isMaster()) {
                PageHandler page = this.service.getPage(null, acceptTeartbeatDate, false, null, null, null, null);
                for (SysCluster cluster : page.getList()) {
                    this.service.delete((Serializable)((Object)cluster.getUuid()));
                }
            } else {
                PageHandler page = this.service.getPage(null, null, true, "heartbeatDate", "desc", null, null);
                if (page.getTotalCount() == 0) {
                    this.upgrade();
                } else if (page.getTotalCount() == 1) {
                    SysCluster master = (SysCluster)page.getList().get(0);
                    if (acceptTeartbeatDate.after(master.getHeartbeatDate())) {
                        this.upgrade();
                        this.service.delete((Serializable)((Object)master.getUuid()));
                    }
                } else {
                    boolean skip = false;
                    for (SysCluster cluster : page.getList()) {
                        if (skip) {
                            this.service.updateMaster((Serializable)((Object)cluster.getUuid()), false);
                            continue;
                        }
                        skip = true;
                    }
                }
            }
            this.scheduledTask.init(lastHeartbeatDate);
        }
    }

    @PreDestroy
    public void destroy() {
        if (CmsVersion.isInitialized()) {
            this.service.delete((Serializable)((Object)CmsVersion.getClusterId()));
        }
    }
}

