/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.component.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.publiccms.common.base.Base;
import com.publiccms.common.cache.CacheEntity;
import com.publiccms.common.cache.CacheEntityFactory;
import com.publiccms.common.tools.CommonUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.publiccms.common.api.Config;
import org.publiccms.common.api.SiteCache;
import org.publiccms.common.tools.ExtendUtils;
import org.publiccms.entities.sys.SysConfigData;
import org.publiccms.entities.sys.SysConfigDataId;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.site.SiteComponent;
import org.publiccms.logic.service.sys.SysConfigDataService;
import org.publiccms.views.pojo.ExtendField;
import org.publiccms.views.pojo.SysConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigComponent
implements SiteCache,
Base {
    @Autowired
    private SysConfigDataService service;
    @Autowired(required=false)
    private List<Config> configPluginList;
    private CacheEntity<Integer, Map<String, Map<String, String>>> cache;
    @Autowired
    private SiteComponent siteComponent;

    public ConfigInfo getConfig(SysSite site, String code, Locale locale) {
        Map<String, SysConfig> map = this.getMap(site);
        SysConfig entity = map.get(code);
        ConfigInfo configInfo = null;
        if (null != entity) {
            configInfo = new ConfigInfo(entity.getCode(), entity.getDescription());
            configInfo.setCustomed(true);
        }
        if (CommonUtils.notEmpty(this.configPluginList)) {
            for (Config configPlugin : this.configPluginList) {
                if (!configPlugin.getCode(site).equals(code)) continue;
                configInfo = new ConfigInfo(code, configPlugin.getCodeDescription(site, locale));
            }
        }
        return configInfo;
    }

    public List<ConfigInfo> getConfigList(SysSite site, Locale locale) {
        ArrayList<ConfigInfo> configList = new ArrayList<ConfigInfo>();
        ArrayList<String> configCodeList = new ArrayList<String>();
        if (CommonUtils.notEmpty(this.configPluginList)) {
            for (Config config : this.configPluginList) {
                String code = config.getCode(site);
                if (configCodeList.contains(code)) continue;
                configList.add(new ConfigInfo(config.getCode(site), config.getCodeDescription(site, locale)));
                configCodeList.add(code);
            }
        }
        for (Map.Entry entry : this.getMap(site).entrySet()) {
            if (configCodeList.contains(entry.getKey())) continue;
            ConfigInfo configInfo = new ConfigInfo((String)entry.getKey(), ((SysConfig)entry.getValue()).getDescription());
            configInfo.setCustomed(true);
            configList.add(configInfo);
            configCodeList.add((String)entry.getKey());
        }
        return configList;
    }

    public List<ExtendField> getFieldList(SysSite site, String code, Boolean customed, Locale locale) {
        SysConfig sysConfig;
        ArrayList<ExtendField> fieldList = new ArrayList<ExtendField>();
        if ((CommonUtils.empty(customed) || !customed.booleanValue()) && CommonUtils.notEmpty(this.configPluginList)) {
            for (Config config : this.configPluginList) {
                if (!config.getCode(site).equals(code)) continue;
                fieldList.addAll(config.getExtendFieldList(site, locale));
            }
        }
        if ((CommonUtils.empty(customed) || customed.booleanValue()) && null != (sysConfig = this.getMap(site).get(code)) && CommonUtils.notEmpty(sysConfig.getExtendList())) {
            fieldList.addAll(sysConfig.getExtendList());
        }
        return fieldList;
    }

    public Map<String, String> getConfigData(int siteId, String code) {
        Map<String, String> configMap;
        Map<String, Map<String, String>> siteMap = this.cache.get(siteId);
        if (CommonUtils.empty(siteMap)) {
            siteMap = new HashMap<String, Map<String, String>>();
        }
        if (CommonUtils.empty(configMap = siteMap.get(code))) {
            SysConfigData entity = (SysConfigData)this.service.getEntity(new SysConfigDataId(siteId, code));
            configMap = null != entity && CommonUtils.notEmpty(entity.getData()) ? ExtendUtils.getExtendMap(entity.getData()) : new HashMap<String, String>();
            siteMap.put(code, configMap);
            this.cache.put(siteId, siteMap);
        }
        return configMap;
    }

    public Map<String, SysConfig> getMap(SysSite site) {
        Map<String, SysConfig> modelMap;
        File file = new File(this.siteComponent.getConfigFilePath(site));
        if (CommonUtils.notEmpty(file)) {
            try {
                modelMap = (Map)objectMapper.readValue(file, (TypeReference)new TypeReference<Map<String, SysConfig>>(){});
            }
            catch (IOException | ClassCastException e) {
                modelMap = new HashMap();
            }
        } else {
            modelMap = new HashMap<String, SysConfig>();
        }
        return modelMap;
    }

    public boolean save(SysSite site, Map<String, SysConfig> modelMap) {
        File file = new File(this.siteComponent.getConfigFilePath(site));
        if (CommonUtils.empty(file)) {
            file.getParentFile().mkdirs();
        }
        try {
            objectMapper.writeValue(file, modelMap);
            file.setReadable(true, false);
            file.setWritable(true, false);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void removeCache(int siteId, String code) {
        Map<String, Map<String, String>> map = this.cache.get(siteId);
        if (CommonUtils.notEmpty(map)) {
            map.remove(code);
        }
    }

    @Override
    public void clear(int siteId) {
        this.cache.remove(siteId);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Autowired
    public void initCache(CacheEntityFactory cacheEntityFactory) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.cache = cacheEntityFactory.createCacheEntity("config");
    }

    public class ConfigInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String code;
        private String description;
        private boolean customed;

        public ConfigInfo(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean isCustomed() {
            return this.customed;
        }

        public void setCustomed(boolean customed) {
            this.customed = customed;
        }
    }
}

