/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.logic.component.cache;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PreDestroy;
import org.publiccms.common.api.Cache;
import org.publiccms.logic.service.tools.HqlService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.view.AbstractCachingViewResolver;

@Component
public class CacheComponent {
    @Autowired
    private List<Cache> cacheableList;
    private List<AbstractCachingViewResolver> cachingViewResolverList = new ArrayList<AbstractCachingViewResolver>();
    @Autowired
    private HqlService hqlService;

    @PreDestroy
    public void clear() {
        for (Cache cache : this.cacheableList) {
            cache.clear();
        }
        this.clearViewCache();
        this.hqlService.clear();
    }

    public void clearViewCache() {
        for (AbstractCachingViewResolver cachingViewResolver : this.cachingViewResolverList) {
            cachingViewResolver.clearCache();
        }
    }

    public void registerCachingViewResolverList(AbstractCachingViewResolver cachingViewResolver) {
        this.cachingViewResolverList.add(cachingViewResolver);
    }
}

