/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.web.sys;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.ControllerUtils;
import com.publiccms.common.tools.FreeMarkerUtils;
import com.publiccms.common.tools.RequestUtils;
import com.publiccms.common.tools.VerificationUtils;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.mail.MessagingException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.publiccms.common.base.AbstractController;
import org.publiccms.common.constants.CommonConstants;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysEmailToken;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.entities.sys.SysUser;
import org.publiccms.logic.component.config.ConfigComponent;
import org.publiccms.logic.component.site.EmailComponent;
import org.publiccms.logic.component.template.TemplateComponent;
import org.publiccms.logic.service.sys.SysEmailTokenService;
import org.publiccms.logic.service.sys.SysUserService;
import org.publiccms.logic.service.sys.SysUserTokenService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"user"})
public class UserController
extends AbstractController {
    @Autowired
    private SysUserService service;
    @Autowired
    private SysUserTokenService sysUserTokenService;
    @Autowired
    private EmailComponent emailComponent;
    @Autowired
    private TemplateComponent templateComponent;
    @Autowired
    private SysEmailTokenService sysEmailTokenService;
    @Autowired
    private ConfigComponent configComponent;

    @RequestMapping(value={"changePassword"}, method={RequestMethod.POST})
    public String changePassword(String oldpassword, String password, String repassword, String returnUrl, HttpServletRequest request, HttpSession session, HttpServletResponse response, ModelMap model) {
        String[] userData;
        String value;
        SysUser user;
        SysSite site = this.getSite(request);
        if (CommonUtils.empty(returnUrl)) {
            returnUrl = site.getDynamicPath();
        }
        if (null == (user = UserController.getUserFromSession(session)) || ControllerUtils.verifyNotEmpty("password", password, (Map<String, Object>)model) || ControllerUtils.verifyNotEquals("repassword", password, repassword, (Map<String, Object>)model) || ControllerUtils.verifyNotEquals("password", user.getPassword(), VerificationUtils.encode(oldpassword), (Map<String, Object>)model)) {
            return "redirect:" + returnUrl;
        }
        Cookie userCookie = RequestUtils.getCookie(request.getCookies(), CommonConstants.getCookiesUser());
        if (null != userCookie && CommonUtils.notEmpty(userCookie.getValue()) && null != (value = userCookie.getValue()) && (userData = value.split(CommonConstants.getCookiesUserSplit())).length > 1) {
            this.sysUserTokenService.delete((Serializable)((Object)userData[1]));
        }
        UserController.clearUserToSession(request.getContextPath(), session, response);
        this.service.updatePassword(user.getId(), VerificationUtils.encode(password));
        model.addAttribute("message", (Object)"success");
        this.logOperateService.save(new LogOperate(site.getId(), user.getId(), "web", "changepassword", RequestUtils.getIpAddress(request), CommonUtils.getDate(), user.getPassword()));
        return "redirect:" + returnUrl;
    }

    @RequestMapping(value={"saveEmail"}, method={RequestMethod.POST})
    public String saveEmail(String email, String returnUrl, HttpServletRequest request, HttpSession session, HttpServletResponse response, ModelMap model) {
        SysSite site = this.getSite(request);
        if (CommonUtils.empty(returnUrl)) {
            returnUrl = site.getDynamicPath();
        }
        Map<String, String> config = this.configComponent.getConfigData(site.getId(), "email");
        String emailTitle = config.get("email_title");
        String emailPath = config.get("email_path");
        if (ControllerUtils.verifyNotEmpty("email", email, (Map<String, Object>)model) || ControllerUtils.verifyNotEmpty("email.config", emailTitle, (Map<String, Object>)model) || ControllerUtils.verifyNotEmpty("email.config", emailPath, (Map<String, Object>)model) || UserController.verifyNotEMail("email", email, (Map<String, Object>)model) || ControllerUtils.verifyHasExist("email", this.service.findByEmail(site.getId(), email), (Map<String, Object>)model)) {
            return "redirect:" + returnUrl;
        }
        SysUser user = UserController.getUserFromSession(session);
        SysEmailToken sysEmailToken = new SysEmailToken();
        sysEmailToken.setUserId(user.getId());
        sysEmailToken.setAuthToken(UUID.randomUUID().toString());
        sysEmailToken.setEmail(email);
        this.sysEmailTokenService.save(sysEmailToken);
        try {
            HashMap<String, Object> emailModel = new HashMap<String, Object>();
            emailModel.put("user", user);
            emailModel.put("site", site);
            emailModel.put("email", email);
            emailModel.put("authToken", sysEmailToken.getAuthToken());
            if (this.emailComponent.sendHtml(site.getId(), email, FreeMarkerUtils.generateStringByString(emailTitle, this.templateComponent.getWebConfiguration(), emailModel), FreeMarkerUtils.generateStringByFile(emailPath, this.templateComponent.getWebConfiguration(), emailModel))) {
                model.addAttribute("message", (Object)"sendEmail.success");
            } else {
                model.addAttribute("message", (Object)"sendEmail.error");
            }
        }
        catch (TemplateException | IOException | MessagingException e) {
            model.addAttribute("error", (Object)"sendEmail.error");
        }
        return "redirect:" + returnUrl;
    }

    @RequestMapping(value={"verifyEmail"}, method={RequestMethod.POST})
    public String verifyEmail(String authToken, String returnUrl, HttpServletRequest request, HttpSession session, HttpServletResponse response, ModelMap model) {
        SysSite site = this.getSite(request);
        if (CommonUtils.empty(returnUrl)) {
            returnUrl = site.getDynamicPath();
        }
        SysEmailToken sysEmailToken = (SysEmailToken)this.sysEmailTokenService.getEntity((Serializable)((Object)authToken));
        if (ControllerUtils.verifyNotEmpty("verifyEmail.authToken", authToken, (Map<String, Object>)model) || ControllerUtils.verifyNotExist("verifyEmail.sysEmailToken", sysEmailToken, (Map<String, Object>)model)) {
            return "redirect:" + returnUrl;
        }
        this.sysEmailTokenService.delete((Serializable)((Object)sysEmailToken.getAuthToken()));
        this.service.checked(Long.valueOf(sysEmailToken.getUserId()), sysEmailToken.getEmail());
        UserController.clearUserTimeToSession(session);
        model.addAttribute("message", (Object)"verifyEmail.success");
        return "redirect:" + returnUrl;
    }
}

