/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.web.cms;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.ControllerUtils;
import com.publiccms.common.tools.RequestUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.ArrayUtils;
import org.publiccms.common.base.AbstractController;
import org.publiccms.common.tools.ExtendUtils;
import org.publiccms.entities.cms.CmsPlace;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.entities.sys.SysUser;
import org.publiccms.logic.component.site.StatisticsComponent;
import org.publiccms.logic.component.template.MetadataComponent;
import org.publiccms.logic.component.template.TemplateComponent;
import org.publiccms.logic.service.cms.CmsPlaceAttributeService;
import org.publiccms.logic.service.cms.CmsPlaceService;
import org.publiccms.views.pojo.CmsPlaceMetadata;
import org.publiccms.views.pojo.CmsPlaceParamters;
import org.publiccms.views.pojo.CmsPlaceStatistics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"place"})
public class PlaceController
extends AbstractController {
    @Autowired
    private CmsPlaceService service;
    @Autowired
    private StatisticsComponent statisticsComponent;
    @Autowired
    private CmsPlaceAttributeService attributeService;
    @Autowired
    private MetadataComponent metadataComponent;
    private String[] ignoreProperties = new String[]{"id", "siteId", "type", "path", "createDate", "userId", "disabled"};

    @RequestMapping(value={"save"})
    public String save(CmsPlace entity, String returnUrl, @ModelAttribute CmsPlaceParamters placeParamters, HttpServletRequest request, HttpSession session, HttpServletResponse response, ModelMap model) {
        SysSite site = this.getSite(request);
        if (CommonUtils.empty(returnUrl)) {
            returnUrl = site.getDynamicPath();
        }
        if (null != entity && CommonUtils.notEmpty(entity.getPath())) {
            entity.setPath(entity.getPath().replace("//", "/"));
            String filePath = this.siteComponent.getWebTemplateFilePath(site, TemplateComponent.INCLUDE_DIRECTORY + entity.getPath());
            CmsPlaceMetadata metadata = this.metadataComponent.getPlaceMetadata(filePath);
            SysUser user = PlaceController.getUserFromSession(session);
            if (ControllerUtils.verifyCustom("contribute", null == metadata || !metadata.isAllowContribute() || 0 >= metadata.getSize() || null == user && !metadata.isAllowAnonymous(), (Map<String, Object>)model)) {
                return "redirect:" + returnUrl;
            }
            if (null != entity.getId()) {
                CmsPlace oldEntity = (CmsPlace)this.service.getEntity(entity.getId());
                if (null == oldEntity || CommonUtils.empty(oldEntity.getUserId()) || null == user || ControllerUtils.verifyNotEquals("siteId", site.getId(), oldEntity.getSiteId(), (Map<String, Object>)model) || ControllerUtils.verifyNotEquals("siteId", user.getId(), oldEntity.getUserId(), (Map<String, Object>)model)) {
                    return "redirect:" + returnUrl;
                }
                entity = this.service.update(entity.getId(), entity, this.ignoreProperties);
                this.logOperateService.save(new LogOperate(site.getId(), user.getId(), "web", "update.place", RequestUtils.getIpAddress(request), CommonUtils.getDate(), entity.getPath()));
            } else {
                entity.setSiteId(site.getId());
                Long userId = null;
                if (null != user) {
                    userId = user.getId();
                    entity.setUserId(user.getId());
                }
                this.service.save(entity);
                this.logOperateService.save(new LogOperate(site.getId(), userId, "web", "save.place", RequestUtils.getIpAddress(request), CommonUtils.getDate(), entity.getPath()));
            }
            Map<String, String> map = ExtendUtils.getExtentDataMap(placeParamters.getExtendDataList(), this.metadataComponent.getPlaceMetadata(filePath).getExtendList());
            String extentString = ExtendUtils.getExtendString(map);
            this.attributeService.updateAttribute(entity.getId(), extentString);
        }
        return "redirect:" + returnUrl;
    }

    @RequestMapping(value={"delete"})
    public String delete(Long id, String returnUrl, HttpServletRequest request, HttpSession session, HttpServletResponse response, ModelMap model) {
        SysSite site = this.getSite(request);
        if (CommonUtils.empty(returnUrl)) {
            returnUrl = site.getDynamicPath();
        }
        CmsPlace entity = (CmsPlace)this.service.getEntity(id);
        SysUser user = PlaceController.getUserFromSession(session);
        String filePath = this.siteComponent.getWebTemplateFilePath(site, TemplateComponent.INCLUDE_DIRECTORY + entity.getPath());
        CmsPlaceMetadata metadata = this.metadataComponent.getPlaceMetadata(filePath);
        if (ControllerUtils.verifyCustom("manage", null == entity || null == user || CommonUtils.empty(metadata.getAdminIds()) || !ArrayUtils.contains((Object[])metadata.getAdminIds(), (Object)user.getId()), (Map<String, Object>)model) || ControllerUtils.verifyNotEquals("siteId", site.getId(), entity.getSiteId(), (Map<String, Object>)model)) {
            return "redirect:" + returnUrl;
        }
        this.service.delete(id);
        this.logOperateService.save(new LogOperate(site.getId(), user.getId(), "web", "delete.place", RequestUtils.getIpAddress(request), CommonUtils.getDate(), id.toString()));
        return "redirect:" + returnUrl;
    }

    @RequestMapping(value={"check"})
    public String check(Long id, String returnUrl, HttpServletRequest request, HttpSession session, HttpServletResponse response, ModelMap model) {
        SysSite site = this.getSite(request);
        if (CommonUtils.empty(returnUrl)) {
            returnUrl = site.getDynamicPath();
        }
        CmsPlace entity = (CmsPlace)this.service.getEntity(id);
        SysUser user = PlaceController.getUserFromSession(session);
        String filePath = this.siteComponent.getWebTemplateFilePath(site, TemplateComponent.INCLUDE_DIRECTORY + entity.getPath());
        CmsPlaceMetadata metadata = this.metadataComponent.getPlaceMetadata(filePath);
        if (ControllerUtils.verifyCustom("manage", null == entity || null == user || CommonUtils.empty(metadata.getAdminIds()) || !ArrayUtils.contains((Object[])metadata.getAdminIds(), (Object)user.getId()), (Map<String, Object>)model) || ControllerUtils.verifyNotEquals("siteId", site.getId(), entity.getSiteId(), (Map<String, Object>)model)) {
            return "redirect:" + returnUrl;
        }
        this.service.check(id);
        this.logOperateService.save(new LogOperate(site.getId(), user.getId(), "web", "check.place", RequestUtils.getIpAddress(request), CommonUtils.getDate(), id.toString()));
        return "redirect:" + returnUrl;
    }

    @RequestMapping(value={"redirect"})
    public void clicks(Long id, HttpServletRequest request, HttpServletResponse response) {
        SysSite site = this.getSite(request);
        CmsPlaceStatistics placeStatistics = this.statisticsComponent.placeClicks(id);
        if (null != placeStatistics && null != placeStatistics.getEntity() && site.getId().intValue() == placeStatistics.getEntity().getSiteId() && CommonUtils.notEmpty(placeStatistics.getEntity().getUrl())) {
            ControllerUtils.redirectPermanently(response, placeStatistics.getEntity().getUrl());
        } else {
            ControllerUtils.redirectPermanently(response, site.getDynamicPath());
        }
    }
}

