/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.web.cms;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.ControllerUtils;
import com.publiccms.common.tools.HtmlUtils;
import com.publiccms.common.tools.JsonUtils;
import com.publiccms.common.tools.RequestUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.ArrayUtils;
import org.publiccms.common.base.AbstractController;
import org.publiccms.common.tools.ExtendUtils;
import org.publiccms.entities.cms.CmsCategory;
import org.publiccms.entities.cms.CmsCategoryModel;
import org.publiccms.entities.cms.CmsCategoryModelId;
import org.publiccms.entities.cms.CmsContent;
import org.publiccms.entities.cms.CmsContentAttribute;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysExtendField;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.entities.sys.SysUser;
import org.publiccms.logic.component.site.StatisticsComponent;
import org.publiccms.logic.component.template.ModelComponent;
import org.publiccms.logic.service.cms.CmsCategoryModelService;
import org.publiccms.logic.service.cms.CmsCategoryService;
import org.publiccms.logic.service.cms.CmsContentAttributeService;
import org.publiccms.logic.service.cms.CmsContentFileService;
import org.publiccms.logic.service.cms.CmsContentService;
import org.publiccms.logic.service.sys.SysExtendFieldService;
import org.publiccms.logic.service.sys.SysExtendService;
import org.publiccms.views.pojo.CmsContentParamters;
import org.publiccms.views.pojo.CmsContentRelatedStatistics;
import org.publiccms.views.pojo.CmsContentStatistics;
import org.publiccms.views.pojo.CmsModel;
import org.publiccms.views.pojo.ExtendField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"content"})
public class ContentController
extends AbstractController {
    @Autowired
    private CmsContentService service;
    @Autowired
    private StatisticsComponent statisticsComponent;
    @Autowired
    private CmsCategoryModelService categoryModelService;
    @Autowired
    private CmsCategoryService categoryService;
    @Autowired
    private ModelComponent modelComponent;
    @Autowired
    private CmsContentAttributeService attributeService;
    @Autowired
    private SysExtendService extendService;
    @Autowired
    private SysExtendFieldService extendFieldService;
    @Autowired
    private CmsContentFileService contentFileService;
    private String[] ignoreProperties = new String[]{"siteId", "userId", "categoryId", "tagIds", "createDate", "clicks", "comments", "scores", "childs", "checkUserId"};
    private String[] ignorePropertiesWithUrl = (String[])ArrayUtils.addAll((Object[])this.ignoreProperties, (Object[])new String[]{"url"});

    @RequestMapping(value={"save"}, method={RequestMethod.POST})
    public String save(CmsContent entity, CmsContentAttribute attribute, @ModelAttribute CmsContentParamters contentParamters, String returnUrl, HttpServletRequest request, HttpSession session, HttpServletResponse response, ModelMap model) {
        SysSite site = this.getSite(request);
        if (CommonUtils.empty(returnUrl)) {
            returnUrl = site.getDynamicPath();
        }
        SysUser user = ContentController.getUserFromSession(session);
        CmsCategoryModel categoryModel = (CmsCategoryModel)this.categoryModelService.getEntity(new CmsCategoryModelId(entity.getCategoryId(), entity.getModelId()));
        if (ControllerUtils.verifyNotEmpty("categoryModel", categoryModel, (Map<String, Object>)model) || ControllerUtils.verifyCustom("contribute", null == user, (Map<String, Object>)model)) {
            return "redirect:" + returnUrl;
        }
        CmsCategory category = (CmsCategory)this.categoryService.getEntity(Integer.valueOf(entity.getCategoryId()));
        if (!(null == category || site.getId().intValue() == category.getSiteId() && category.isAllowContribute())) {
            category = null;
        }
        CmsModel cmsModel = this.modelComponent.getMap(site).get(entity.getModelId());
        if (ControllerUtils.verifyNotEmpty("category", category, (Map<String, Object>)model) || ControllerUtils.verifyNotEmpty("model", cmsModel, (Map<String, Object>)model)) {
            return "redirect:" + returnUrl;
        }
        entity.setHasFiles(cmsModel.isHasFiles());
        entity.setHasImages(cmsModel.isHasImages());
        entity.setOnlyUrl(cmsModel.isOnlyUrl());
        entity.setStatus(2);
        if (null != entity.getId()) {
            CmsContent oldEntity = (CmsContent)this.service.getEntity(entity.getId());
            if (null == oldEntity || ControllerUtils.verifyNotEquals("siteId", site.getId(), oldEntity.getSiteId(), (Map<String, Object>)model)) {
                return "redirect:" + returnUrl;
            }
            if (null != (entity = this.service.update(entity.getId(), entity, entity.isOnlyUrl() ? this.ignoreProperties : this.ignorePropertiesWithUrl)).getId()) {
                this.logOperateService.save(new LogOperate(site.getId(), user.getId(), "web", "update.content", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
            }
        } else {
            entity.setSiteId(site.getId());
            entity.setUserId(user.getId());
            this.service.save(entity);
            if (CommonUtils.notEmpty(entity.getParentId())) {
                this.service.updateChilds(entity.getParentId(), 1);
            } else {
                this.categoryService.updateContents(Integer.valueOf(entity.getCategoryId()), 1);
            }
            this.logOperateService.save(new LogOperate(site.getId(), user.getId(), "web", "save.content", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        if (entity.isHasImages() || entity.isHasFiles()) {
            this.contentFileService.update(entity.getId(), user.getId(), entity.isHasFiles() ? contentParamters.getFiles() : null, entity.isHasImages() ? contentParamters.getImages() : null);
        }
        if (null != attribute.getText()) {
            attribute.setWordCount(HtmlUtils.removeHtmlTag(attribute.getText()).length());
        }
        List<ExtendField> modelExtendList = cmsModel.getExtendList();
        Map<String, String> map = ExtendUtils.getExtentDataMap(contentParamters.getModelExtendDataList(), modelExtendList);
        if (null != category && null != this.extendService.getEntity(category.getExtendId())) {
            List<SysExtendField> categoryExtendList = this.extendFieldService.getList(category.getExtendId());
            Map<String, String> categoryMap = ExtendUtils.getSysExtentDataMap(contentParamters.getCategoryExtendDataList(), categoryExtendList);
            if (CommonUtils.notEmpty(map)) {
                map.putAll(categoryMap);
            } else {
                map = categoryMap;
            }
        }
        if (CommonUtils.notEmpty(map)) {
            attribute.setData(ExtendUtils.getExtendString(map));
        } else {
            attribute.setData(null);
        }
        this.attributeService.updateAttribute(entity.getId(), attribute);
        return "redirect:" + returnUrl;
    }

    @RequestMapping(value={"related/redirect"})
    public void relatedRedirect(Long id, HttpServletRequest request, HttpServletResponse response) {
        CmsContentRelatedStatistics contentRelatedStatistics = this.statisticsComponent.relatedClicks(id);
        SysSite site = this.getSite(request);
        if (null != contentRelatedStatistics && null != contentRelatedStatistics.getEntity()) {
            ControllerUtils.redirectPermanently(response, contentRelatedStatistics.getEntity().getUrl());
        } else {
            ControllerUtils.redirectPermanently(response, site.getDynamicPath());
        }
    }

    @RequestMapping(value={"redirect"})
    public void contentRedirect(Long id, HttpServletRequest request, HttpServletResponse response) {
        CmsContentStatistics contentStatistics = this.statisticsComponent.clicks(id);
        SysSite site = this.getSite(request);
        if (null != contentStatistics && null != contentStatistics.getEntity() && site.getId().intValue() == contentStatistics.getEntity().getSiteId()) {
            ControllerUtils.redirectPermanently(response, contentStatistics.getEntity().getUrl());
        } else {
            ControllerUtils.redirectPermanently(response, site.getDynamicPath());
        }
    }
}

