/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.web;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.ControllerUtils;
import com.publiccms.common.tools.RequestUtils;
import com.publiccms.common.tools.VerificationUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.publiccms.common.base.AbstractController;
import org.publiccms.common.constants.CommonConstants;
import org.publiccms.entities.log.LogLogin;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.entities.sys.SysUser;
import org.publiccms.entities.sys.SysUserToken;
import org.publiccms.logic.component.config.ConfigComponent;
import org.publiccms.logic.service.log.LogLoginService;
import org.publiccms.logic.service.sys.SysUserService;
import org.publiccms.logic.service.sys.SysUserTokenService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class LoginController
extends AbstractController {
    @Autowired
    private SysUserService service;
    @Autowired
    private SysUserTokenService sysUserTokenService;
    @Autowired
    private LogLoginService logLoginService;
    @Autowired
    private ConfigComponent configComponent;

    @RequestMapping(value={"doLogin"}, method={RequestMethod.POST})
    public String login(String username, String password, String returnUrl, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        Map<String, String> config;
        String loginPath;
        SysSite site = this.getSite(request);
        if (CommonUtils.empty(returnUrl)) {
            returnUrl = site.getDynamicPath();
        }
        if (CommonUtils.empty(loginPath = (config = this.configComponent.getConfigData(site.getId(), "site")).get("login_path"))) {
            loginPath = site.getDynamicPath();
        }
        username = StringUtils.trim((String)username);
        password = StringUtils.trim((String)password);
        if (ControllerUtils.verifyNotEmpty("username", username, (Map<String, Object>)model) || ControllerUtils.verifyNotEmpty("password", password, (Map<String, Object>)model)) {
            return "redirect:" + returnUrl;
        }
        SysUser user = LoginController.verifyNotEMail(username) ? this.service.findByName(site.getId(), username) : this.service.findByEmail(site.getId(), username);
        String ip = RequestUtils.getIpAddress(request);
        if (ControllerUtils.verifyNotExist("username", user, (Map<String, Object>)model) || ControllerUtils.verifyNotEquals("password", VerificationUtils.encode(password), user.getPassword(), (Map<String, Object>)model) || this.verifyNotEnablie(user, model)) {
            Long userId = null;
            if (null != user) {
                userId = user.getId();
            }
            this.logLoginService.save(new LogLogin(site.getId(), username, userId, ip, "web", false, CommonUtils.getDate(), password));
            return "redirect:" + returnUrl;
        }
        user.setPassword(null);
        LoginController.setUserToSession(request.getSession(), user);
        String authToken = UUID.randomUUID().toString();
        this.sysUserTokenService.save(new SysUserToken(authToken, site.getId(), user.getId(), "web", CommonUtils.getDate(), ip));
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(user.getId()).append(CommonConstants.getCookiesUserSplit()).append(authToken).append(CommonConstants.getCookiesUserSplit()).append(user.isSuperuserAccess()).append(CommonConstants.getCookiesUserSplit()).append(URLEncoder.encode(user.getNickName(), "UTF-8"));
            RequestUtils.addCookie(request.getContextPath(), response, CommonConstants.getCookiesUser(), sb.toString(), Integer.MAX_VALUE, null);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Object)e);
        }
        this.service.updateLoginStatus(user.getId(), ip);
        this.logLoginService.save(new LogLogin(site.getId(), username, user.getId(), ip, "web", true, CommonUtils.getDate(), null));
        return "redirect:" + returnUrl;
    }

    @RequestMapping(value={"loginStatus"})
    @ResponseBody
    public ModelMap loginStatus(HttpServletRequest request, HttpSession session, HttpServletResponse response, ModelMap model) {
        SysUser user = LoginController.getUserFromSession(session);
        if (null != user) {
            model.addAttribute("id", (Object)user.getId());
            model.addAttribute("name", (Object)user.getName());
            model.addAttribute("nickname", (Object)user.getNickName());
            model.addAttribute("email", (Object)user.getEmail());
            model.addAttribute("emailChecked", (Object)user.isEmailChecked());
            model.addAttribute("superuserAccess", (Object)user.isSuperuserAccess());
        }
        return model;
    }

    @RequestMapping(value={"doRegister"}, method={RequestMethod.POST})
    public String register(SysUser entity, String repassword, String returnUrl, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        SysSite site = this.getSite(request);
        if (CommonUtils.empty(returnUrl)) {
            returnUrl = site.getDynamicPath();
        }
        entity.setName(StringUtils.trim((String)entity.getName()));
        entity.setNickName(StringUtils.trim((String)entity.getNickName()));
        entity.setPassword(StringUtils.trim((String)entity.getPassword()));
        repassword = StringUtils.trim((String)repassword);
        if (ControllerUtils.verifyNotEmpty("username", entity.getName(), (Map<String, Object>)model) || ControllerUtils.verifyNotEmpty("nickname", entity.getNickName(), (Map<String, Object>)model) || ControllerUtils.verifyNotEmpty("password", entity.getPassword(), (Map<String, Object>)model) || LoginController.verifyNotUserName("username", entity.getName(), (Map<String, Object>)model) || LoginController.verifyNotNickName("nickname", entity.getNickName(), (Map<String, Object>)model) || ControllerUtils.verifyNotEquals("repassword", entity.getPassword(), repassword, (Map<String, Object>)model) || ControllerUtils.verifyHasExist("username", this.service.findByName(site.getId(), entity.getName()), (Map<String, Object>)model) || ControllerUtils.verifyHasExist("nickname", this.service.findByNickName(site.getId(), entity.getNickName()), (Map<String, Object>)model)) {
            return "redirect:" + returnUrl;
        }
        String ip = RequestUtils.getIpAddress(request);
        entity.setPassword(VerificationUtils.encode(entity.getPassword()));
        entity.setLastLoginIp(ip);
        entity.setSiteId(site.getId());
        entity.setDisabled(false);
        entity.setRoles(null);
        entity.setSuperuserAccess(false);
        entity.setLoginCount(0);
        entity.setDeptId(null);
        this.service.save(entity);
        this.service.save(entity);
        entity.setPassword(null);
        LoginController.setUserToSession(request.getSession(), entity);
        String authToken = UUID.randomUUID().toString();
        this.sysUserTokenService.save(new SysUserToken(authToken, site.getId(), entity.getId(), "web", CommonUtils.getDate(), ip));
        String loginInfo = entity.getId() + CommonConstants.getCookiesUserSplit() + authToken + CommonConstants.getCookiesUserSplit() + entity.getNickName();
        model.addAttribute("loginInfo", (Object)loginInfo);
        RequestUtils.addCookie(request.getContextPath(), response, CommonConstants.getCookiesUser(), loginInfo, Integer.MAX_VALUE, null);
        return "redirect:" + returnUrl;
    }

    @RequestMapping(value={"doLogout"}, method={RequestMethod.POST})
    public void logout(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        String[] userData;
        String value;
        Cookie userCookie = RequestUtils.getCookie(request.getCookies(), CommonConstants.getCookiesUser());
        if (null != userCookie && CommonUtils.notEmpty(userCookie.getValue()) && null != (value = userCookie.getValue()) && (userData = value.split(CommonConstants.getCookiesUserSplit())).length > 1) {
            this.sysUserTokenService.delete((Serializable)((Object)userData[1]));
        }
        LoginController.clearUserToSession(request.getContextPath(), request.getSession(), response);
    }

    public boolean verifyNotEnablie(SysUser user, ModelMap model) {
        if (user.isDisabled()) {
            model.addAttribute("error", (Object)"verify.user.notEnablie");
            return true;
        }
        return false;
    }
}

