/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.web;

import com.publiccms.common.servlet.PageNotFoundException;
import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.RequestUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.publiccms.common.base.AbstractController;
import org.publiccms.common.constants.CommonConstants;
import org.publiccms.entities.sys.SysDomain;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.config.ConfigComponent;
import org.publiccms.logic.component.template.MetadataComponent;
import org.publiccms.logic.component.template.TemplateCacheComponent;
import org.publiccms.views.pojo.CmsPageMetadata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.util.UrlPathHelper;

@Controller
public class IndexController
extends AbstractController {
    @Autowired
    private MetadataComponent metadataComponent;
    @Autowired
    private TemplateCacheComponent templateCacheComponent;
    @Autowired
    private ConfigComponent configComponent;
    private UrlPathHelper urlPathHelper = new UrlPathHelper();

    @RequestMapping(value={"/", "/**"})
    public String page(@RequestBody(required=false) String body, HttpServletRequest request, ModelMap model) throws PageNotFoundException {
        String requestPath = this.urlPathHelper.getLookupPathForRequest(request);
        if (requestPath.endsWith("/")) {
            requestPath = requestPath + CommonConstants.getDefaultPage();
        }
        SysDomain domain = this.getDomain(request);
        SysSite site = this.getSite(request);
        String fullRequestPath = this.siteComponent.getViewNamePreffix(site, domain) + requestPath;
        String templatePath = this.siteComponent.getWebTemplateFilePath() + fullRequestPath;
        CmsPageMetadata metadata = this.metadataComponent.getTemplateMetadata(templatePath, true);
        if (null != metadata) {
            if (metadata.isUseDynamic()) {
                if (metadata.isNeedLogin() && null == IndexController.getUserFromSession(request.getSession())) {
                    Map<String, String> config = this.configComponent.getConfigData(site.getId(), "site");
                    String loginPath = config.get("login_path");
                    StringBuilder sb = new StringBuilder("redirect:");
                    if (CommonUtils.notEmpty(loginPath)) {
                        return sb.append(loginPath).append("?returnUrl=").append(RequestUtils.getEncodePath(requestPath, request.getQueryString())).toString();
                    }
                    return sb.append(site.getDynamicPath()).toString();
                }
                model.put((Object)"metadata", (Object)metadata);
                if (metadata.isNeedBody()) {
                    model.put((Object)"body", (Object)body);
                }
                if (CommonUtils.notEmpty(metadata.getAcceptParamters())) {
                    IndexController.billingRequestParamtersToModel(request, metadata.getAcceptParamters(), model);
                }
                if (CommonUtils.notEmpty(metadata.getCacheTime()) && 0 < metadata.getCacheTime()) {
                    int cacheMillisTime = metadata.getCacheTime() * 1000;
                    String cacheControl = request.getHeader("Cache-Control");
                    String pragma = request.getHeader("Pragma");
                    if (CommonUtils.notEmpty(cacheControl) && "no-cache".equalsIgnoreCase(cacheControl) || CommonUtils.notEmpty(pragma) && "no-cache".equalsIgnoreCase(pragma)) {
                        cacheMillisTime = 0;
                    }
                    return this.templateCacheComponent.getCachedPath(requestPath, fullRequestPath, cacheMillisTime, metadata.getAcceptParamters(), request, model);
                }
            } else {
                throw new PageNotFoundException(requestPath);
            }
        }
        return requestPath;
    }

    private static void billingRequestParamtersToModel(HttpServletRequest request, String acceptParamters, ModelMap model) {
        for (String paramterName : StringUtils.split((String)acceptParamters, (String)",")) {
            Object[] values = request.getParameterValues(paramterName);
            if (!ArrayUtils.isNotEmpty((Object[])values)) continue;
            if (1 < values.length) {
                model.put((Object)paramterName, (Object)values);
                continue;
            }
            model.put((Object)paramterName, values[0]);
        }
    }
}

