/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.api;

import com.publiccms.common.base.BaseMethod;
import com.publiccms.common.tools.CommonUtils;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.publiccms.common.base.AbstractController;
import org.publiccms.controller.api.ApiController;
import org.publiccms.entities.sys.SysApp;
import org.publiccms.entities.sys.SysAppToken;
import org.publiccms.logic.component.site.DirectiveComponent;
import org.publiccms.logic.component.template.TemplateComponent;
import org.publiccms.logic.service.sys.SysAppService;
import org.publiccms.logic.service.sys.SysAppTokenService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MethodController
extends AbstractController {
    private Map<String, BaseMethod> methodMap;
    private List<Map<String, String>> methodList = new ArrayList<Map<String, String>>();
    private ObjectWrapper objectWrapper;
    @Autowired
    private SysAppTokenService appTokenService;
    @Autowired
    private SysAppService appService;
    @Autowired
    private TemplateComponent templateComponent;

    @RequestMapping(value={"method/{name}"})
    public Object method(@PathVariable String name, String appToken, HttpServletRequest request, HttpServletResponse response) {
        BaseMethod method = this.methodMap.get(name);
        if (null != method) {
            try {
                Object[] paramters;
                if (method.needAppToken()) {
                    SysAppToken token = (SysAppToken)this.appTokenService.getEntity((Serializable)((Object)appToken));
                    if (null == token) {
                        return ApiController.NEED_APP_TOKEN_MAP;
                    }
                    SysApp app = (SysApp)this.appService.getEntity(Integer.valueOf(token.getAppId()));
                    if (null == app) {
                        return ApiController.NEED_APP_TOKEN_MAP;
                    }
                }
                if (CommonUtils.notEmpty(paramters = request.getParameterValues("paramters")) && paramters.length >= method.minParamtersNumber()) {
                    ArrayList<TemplateModel> list = new ArrayList<TemplateModel>();
                    for (Object paramter : paramters) {
                        list.add(this.getObjectWrapper().wrap(paramter));
                    }
                    return method.exec(list);
                }
                if (CommonUtils.empty(paramters) && 0 == method.minParamtersNumber()) {
                    return method.exec(null);
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("error", "paramtersError");
                return map;
            }
            catch (TemplateModelException e) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("error", e.getMessage());
                return map;
            }
        }
        return ApiController.NOT_FOUND_MAP;
    }

    @RequestMapping(value={"methods"})
    public List<Map<String, String>> methods() {
        return this.methodList;
    }

    @Autowired
    public void init(DirectiveComponent directiveComponent) {
        this.methodMap = directiveComponent.getMethodMap();
        for (Map.Entry<String, BaseMethod> entry : this.methodMap.entrySet()) {
            if (!entry.getValue().httpEnabled()) continue;
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("name", entry.getKey());
            resultMap.put("minParamters", String.valueOf(entry.getValue().minParamtersNumber()));
            resultMap.put("needAppToken", String.valueOf(entry.getValue().needAppToken()));
            resultMap.put("needUserToken", String.valueOf(false));
            this.methodList.add(resultMap);
        }
    }

    private ObjectWrapper getObjectWrapper() {
        if (null == this.objectWrapper) {
            this.objectWrapper = this.templateComponent.getWebConfiguration().getObjectWrapper();
        }
        return this.objectWrapper;
    }
}

