/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.api;

import com.publiccms.common.directive.BaseTemplateDirective;
import com.publiccms.common.directive.HttpDirective;
import com.publiccms.common.handler.HttpParameterHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.publiccms.common.base.AbstractController;
import org.publiccms.common.base.AbstractTemplateDirective;
import org.publiccms.logic.component.site.DirectiveComponent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DirectiveController
extends AbstractController {
    private Map<String, BaseTemplateDirective> actionMap = new HashMap<String, BaseTemplateDirective>();
    private List<Map<String, String>> actionList = new ArrayList<Map<String, String>>();

    @RequestMapping(value={"directive/{action}"})
    public void directive(@PathVariable String action, String callback, HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpDirective directive = this.actionMap.get(action);
            if (null != directive) {
                request.setAttribute("site", (Object)this.getSite(request));
                directive.execute((HttpMessageConverter<Object>)this.mappingJackson2HttpMessageConverter, jsonMediaType, request, callback, response);
            } else {
                HttpParameterHandler handler = new HttpParameterHandler((HttpMessageConverter<Object>)this.mappingJackson2HttpMessageConverter, jsonMediaType, request, callback, response);
                handler.put("error", "interfaceNotFound");
            }
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage());
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
    }

    @RequestMapping(value={"directives"})
    @ResponseBody
    public List<Map<String, String>> directives() {
        return this.actionList;
    }

    @Autowired
    public void init(DirectiveComponent directiveComponent) {
        HashMap<String, String> map;
        this.actionMap.putAll(directiveComponent.getTemplateDirectiveMap());
        for (Map.Entry<String, AbstractTemplateDirective> entry : directiveComponent.getTemplateDirectiveMap().entrySet()) {
            map = new HashMap<String, String>();
            map.put("name", entry.getKey());
            map.put("needAppToken", String.valueOf(entry.getValue().needAppToken()));
            map.put("needUserToken", String.valueOf(entry.getValue().needUserToken()));
            this.actionList.add(map);
        }
        this.actionMap.putAll(directiveComponent.getTaskDirectiveMap());
        for (Map.Entry<String, BaseTemplateDirective> entry : directiveComponent.getTaskDirectiveMap().entrySet()) {
            map = new HashMap();
            map.put("name", entry.getKey());
            map.put("needAppToken", String.valueOf(true));
            map.put("needUserToken", String.valueOf(false));
            this.actionList.add(map);
        }
    }
}

