/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.api;

import com.publiccms.common.handler.HttpParameterHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.publiccms.common.base.AbstractAppDirective;
import org.publiccms.common.base.AbstractController;
import org.publiccms.logic.component.site.DirectiveComponent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ApiController
extends AbstractController {
    private Map<String, AbstractAppDirective> appDirectiveMap;
    private List<Map<String, String>> appList = new ArrayList<Map<String, String>>();
    public static final String INTERFACE_NOT_FOUND = "interfaceNotFound";
    public static final String NEED_APP_TOKEN = "needAppToken";
    public static final String UN_AUTHORIZED = "unAuthorized";
    public static final String NEED_LOGIN = "needLogin";
    public static final Map<String, String> NEED_APP_TOKEN_MAP = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("error", ApiController.NEED_APP_TOKEN);
        }
    };
    public static final Map<String, String> NOT_FOUND_MAP = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("error", ApiController.INTERFACE_NOT_FOUND);
        }
    };
    @Autowired
    private DirectiveComponent directiveComponent;

    @RequestMapping(value={"/", "/**"})
    @ResponseBody
    public Map<String, String> api() {
        return NOT_FOUND_MAP;
    }

    @RequestMapping(value={"{api}"})
    public void api(@PathVariable String api, String callback, HttpServletRequest request, HttpServletResponse response) {
        try {
            AbstractAppDirective directive = this.directiveComponent.getAppDirectiveMap().get(api);
            if (null != directive) {
                directive.execute((HttpMessageConverter<Object>)this.mappingJackson2HttpMessageConverter, jsonMediaType, request, callback, response);
            } else {
                HttpParameterHandler handler = new HttpParameterHandler((HttpMessageConverter<Object>)this.mappingJackson2HttpMessageConverter, jsonMediaType, request, callback, response);
                handler.put("error", INTERFACE_NOT_FOUND).render();
            }
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage());
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
    }

    @RequestMapping(value={"apis"})
    @ResponseBody
    public List<Map<String, String>> apis() {
        return this.appList;
    }

    @Autowired(required=false)
    public void init(Map<String, AbstractAppDirective> directiveMap) {
        this.appDirectiveMap = this.directiveComponent.getAppDirectiveMap();
        for (Map.Entry<String, AbstractAppDirective> entry : this.appDirectiveMap.entrySet()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", entry.getKey());
            map.put(NEED_APP_TOKEN, String.valueOf(entry.getValue().needAppToken()));
            map.put("needUserToken", String.valueOf(entry.getValue().needUserToken()));
            this.appList.add(map);
        }
    }
}

