/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.sys;

import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.RequestUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.publiccms.common.base.AbstractController;
import org.publiccms.entities.log.LogUpload;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.site.FileComponent;
import org.publiccms.logic.service.log.LogUploadService;
import org.publiccms.views.pojo.UeditorConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"ueditor"})
public class UeditorAdminController
extends AbstractController {
    @Autowired
    private FileComponent fileComponent;
    @Autowired
    protected LogUploadService logUploadService;
    private static final String ACTION_CONFIG = "config";
    private static final String ACTION_UPLOAD = "upload";
    private static final String ACTION_UPLOAD_SCRAW = "uploadScraw";
    private static final String ACTION_CATCHIMAGE = "catchimage";
    private static final String ACTION_LISTFILE = "listfile";
    private static final String FIELD_NAME = "file";
    private static final String SCRAW_TYPE = ".jpg";
    private static final String[] IMAGE_ALLOW_FILES = new String[]{".png", ".jpg", ".jpeg", ".gif", ".bmp"};
    private static final String[] VIDEO_ALLOW_FILES = new String[]{".flv", ".swf", ".mkv", ".avi", ".rm", ".rmvb", ".mpeg", ".mpg", ".ogg", ".ogv", ".mov", ".wmv", ".mp4", ".webm", ".mp3", ".wav", ".mid"};
    private static final String[] ALLOW_FILES = (String[])ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])VIDEO_ALLOW_FILES, (Object[])IMAGE_ALLOW_FILES), (Object[])new String[]{".rar", ".zip", ".tar", ".gz", ".7z", ".bz2", ".cab", ".iso", ".doc", ".docx", ".xls", ".xlsx", ".ppt", ".pptx", ".pdf", ".txt", ".md", ".xml"});
    private static final Map<String, String> CONTENT_TYPE_MAP = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("image/gif", ".gif");
            this.put("image/jpeg", UeditorAdminController.SCRAW_TYPE);
            this.put("image/jpg", UeditorAdminController.SCRAW_TYPE);
            this.put("image/png", ".png");
            this.put("image/bmp", ".bmp");
        }
    };

    @RequestMapping(params={"action=config"})
    @ResponseBody
    public UeditorConfig config(HttpServletRequest request) {
        String urlPrefix = this.getSite(request).getSitePath();
        UeditorConfig config = new UeditorConfig();
        config.setImageActionName(ACTION_UPLOAD);
        config.setSnapscreenActionName(ACTION_UPLOAD);
        config.setScrawlActionName(ACTION_UPLOAD_SCRAW);
        config.setVideoActionName(ACTION_UPLOAD);
        config.setFileActionName(ACTION_UPLOAD);
        config.setCatcherActionName(ACTION_CATCHIMAGE);
        config.setImageManagerActionName(ACTION_LISTFILE);
        config.setFileManagerActionName(ACTION_LISTFILE);
        config.setImageFieldName(FIELD_NAME);
        config.setScrawlFieldName(FIELD_NAME);
        config.setCatcherFieldName(FIELD_NAME);
        config.setVideoFieldName(FIELD_NAME);
        config.setFileFieldName(FIELD_NAME);
        config.setImageUrlPrefix(urlPrefix);
        config.setScrawlUrlPrefix(urlPrefix);
        config.setSnapscreenUrlPrefix(urlPrefix);
        config.setCatcherUrlPrefix(urlPrefix);
        config.setVideoUrlPrefix(urlPrefix);
        config.setFileUrlPrefix(urlPrefix);
        config.setImageManagerUrlPrefix(urlPrefix);
        config.setFileManagerUrlPrefix(urlPrefix);
        config.setImageAllowFiles(IMAGE_ALLOW_FILES);
        config.setCatcherAllowFiles(IMAGE_ALLOW_FILES);
        config.setVideoAllowFiles(VIDEO_ALLOW_FILES);
        config.setFileAllowFiles(ALLOW_FILES);
        config.setImageManagerAllowFiles(IMAGE_ALLOW_FILES);
        config.setFileManagerAllowFiles(ALLOW_FILES);
        return config;
    }

    @RequestMapping(params={"action=upload"})
    public String upload(MultipartFile file, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        if (null != file && !file.isEmpty()) {
            String originalName = file.getOriginalFilename();
            String suffix = this.fileComponent.getSuffix(originalName);
            String fileName = this.fileComponent.getUploadFileName(suffix);
            try {
                this.fileComponent.upload(file, this.siteComponent.getWebFilePath(site, fileName));
                this.logUploadService.save(new LogUpload(site.getId(), UeditorAdminController.getAdminFromSession(session).getId(), "web_manager", false, file.getSize(), RequestUtils.getIpAddress(request), CommonUtils.getDate(), fileName));
                Map<String, Object> map = UeditorAdminController.getResultMap(true);
                map.put("size", file.getSize());
                map.put("title", originalName);
                map.put("url", fileName);
                map.put("type", suffix);
                map.put("original", originalName);
                model.put((Object)"result", map);
            }
            catch (IOException | IllegalStateException e) {
                model.put((Object)"result", UeditorAdminController.getResultMap(false));
            }
        } else {
            model.put((Object)"result", UeditorAdminController.getResultMap(false));
        }
        return "common/mapResult";
    }

    @RequestMapping(params={"action=uploadScraw"})
    @ResponseBody
    public Map<String, Object> uploadScraw(String file, HttpServletRequest request, HttpSession session) {
        SysSite site = this.getSite(request);
        if (CommonUtils.notEmpty(file)) {
            byte[] data = Base64.decodeBase64((String)file);
            String fileName = this.fileComponent.getUploadFileName(SCRAW_TYPE);
            try {
                File dest = new File(this.siteComponent.getWebFilePath(site, fileName));
                FileUtils.writeByteArrayToFile((File)dest, (byte[])data);
                dest.setReadable(true, false);
                dest.setWritable(true, false);
                this.logUploadService.save(new LogUpload(site.getId(), UeditorAdminController.getAdminFromSession(session).getId(), "web_manager", true, dest.length(), RequestUtils.getIpAddress(request), CommonUtils.getDate(), fileName));
                Map<String, Object> map = UeditorAdminController.getResultMap(true);
                map.put("size", data.length);
                map.put("title", dest.getName());
                map.put("url", fileName);
                map.put("type", SCRAW_TYPE);
                map.put("original", "scraw.jpg");
                return map;
            }
            catch (IOException | IllegalStateException e) {
                this.log.error((Object)e.getMessage());
                return UeditorAdminController.getResultMap(false);
            }
        }
        return UeditorAdminController.getResultMap(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(params={"action=catchimage"})
    @ResponseBody
    public Map<String, Object> catchimage(HttpServletRequest request, HttpSession session) {
        SysSite site = this.getSite(request);
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            Object[] files = request.getParameterValues("file[]");
            if (!CommonUtils.notEmpty(files)) return UeditorAdminController.getResultMap(false);
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            for (Object image : files) {
                HttpGet httpget = new HttpGet((String)image);
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpget);
                HttpEntity entity = response.getEntity();
                if (null != entity) {
                    String suffix = null;
                    if (CommonUtils.notEmpty(entity.getContentType().getElements())) {
                        suffix = CONTENT_TYPE_MAP.get(entity.getContentType().getElements()[0].getName());
                    }
                    if (CommonUtils.empty(suffix)) {
                        suffix = SCRAW_TYPE;
                    }
                    String fileName = this.fileComponent.getUploadFileName(suffix);
                    File dest = new File(this.siteComponent.getWebFilePath(site, fileName));
                    FileUtils.copyInputStreamToFile((InputStream)entity.getContent(), (File)dest);
                    dest.setReadable(true, false);
                    dest.setWritable(true, false);
                    this.logUploadService.save(new LogUpload(site.getId(), UeditorAdminController.getAdminFromSession(session).getId(), "web_manager", true, dest.length(), RequestUtils.getIpAddress(request), CommonUtils.getDate(), fileName));
                    Map<String, Object> map2 = UeditorAdminController.getResultMap(true);
                    map2.put("size", entity.getContentLength());
                    map2.put("title", dest.getName());
                    map2.put("url", fileName);
                    map2.put("source", image);
                    list.add(map2);
                }
                EntityUtils.consume((HttpEntity)entity);
            }
            Map<String, Object> map3 = UeditorAdminController.getResultMap(true);
            map3.put("list", list);
            Map<String, Object> map = map3;
            return map;
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            return UeditorAdminController.getResultMap(false);
        }
    }

    @RequestMapping(params={"action=listfile"})
    @ResponseBody
    public Map<String, Object> listfile(Integer start, HttpServletRequest request, HttpSession session) {
        if (CommonUtils.empty(start)) {
            start = 0;
        }
        PageHandler page = this.logUploadService.getPage(this.getSite(request).getId(), UeditorAdminController.getAdminFromSession(session).getId(), null, null, null, null, null, start / 20 + 1, 20);
        Map<String, Object> map = UeditorAdminController.getResultMap(true);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (LogUpload logUpload : page.getList()) {
            Map<String, Object> tempMap = UeditorAdminController.getResultMap(true);
            tempMap.put("url", logUpload.getFilePath());
            list.add(tempMap);
        }
        map.put("list", list);
        map.put("start", start);
        map.put("total", page.getTotalCount());
        return map;
    }

    private static Map<String, Object> getResultMap(boolean success) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (success) {
            map.put("state", "SUCCESS");
        } else {
            map.put("state", "error");
        }
        return map;
    }
}

