/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.sys;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.ControllerUtils;
import com.publiccms.common.tools.RequestUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.publiccms.common.base.AbstractController;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.site.FileComponent;
import org.publiccms.logic.component.template.TemplateComponent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"taskTemplate"})
public class TaskTemplateAdminController
extends AbstractController {
    @Autowired
    private TemplateComponent templateComponent;
    @Autowired
    private FileComponent fileComponent;

    @RequestMapping(value={"save"})
    public String save(String path, String content, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        if (CommonUtils.notEmpty(path)) {
            try {
                String filePath = this.siteComponent.getTaskTemplateFilePath(site, path);
                File templateFile = new File(filePath);
                if (CommonUtils.notEmpty(templateFile)) {
                    this.fileComponent.updateFile(templateFile, content);
                    this.logOperateService.save(new LogOperate(site.getId(), TaskTemplateAdminController.getAdminFromSession(session).getId(), "web_manager", "update.task.template", RequestUtils.getIpAddress(request), CommonUtils.getDate(), path));
                } else {
                    this.fileComponent.createFile(templateFile, content);
                    this.logOperateService.save(new LogOperate(site.getId(), TaskTemplateAdminController.getAdminFromSession(session).getId(), "web_manager", "save.task.template", RequestUtils.getIpAddress(request), CommonUtils.getDate(), path));
                }
                this.templateComponent.clear();
            }
            catch (IOException e) {
                model.put((Object)"error", (Object)e.getMessage());
                this.log.error((Object)e.getMessage());
                return "common/ajaxError";
            }
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"delete"})
    public String delete(String path, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (CommonUtils.notEmpty(path)) {
            SysSite site = this.getSite(request);
            String filePath = this.siteComponent.getTaskTemplateFilePath(site, path);
            if (ControllerUtils.verifyCustom("notExist.template", !this.fileComponent.deleteFile(filePath), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            this.templateComponent.clear();
            this.logOperateService.save(new LogOperate(site.getId(), TaskTemplateAdminController.getAdminFromSession(session).getId(), "web_manager", "delete.task.template", RequestUtils.getIpAddress(request), CommonUtils.getDate(), path));
        }
        return "common/ajaxDone";
    }
}

