/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.sys;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.ControllerUtils;
import com.publiccms.common.tools.JsonUtils;
import com.publiccms.common.tools.RequestUtils;
import com.publiccms.common.tools.VerificationUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.publiccms.common.base.AbstractController;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysRoleUser;
import org.publiccms.entities.sys.SysRoleUserId;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.entities.sys.SysUser;
import org.publiccms.logic.service.sys.SysRoleUserService;
import org.publiccms.logic.service.sys.SysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"sysUser"})
public class SysUserAdminController
extends AbstractController {
    @Autowired
    private SysUserService service;
    @Autowired
    private SysRoleUserService roleUserService;
    private String[] ignoreProperties = new String[]{"id", "registeredDate", "siteId", "authToken", "lastLoginDate", "lastLoginIp", "loginCount", "disabled"};

    @RequestMapping(value={"save"})
    public String save(SysUser entity, String repassword, Integer[] roleIds, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        entity.setName(org.apache.commons.lang3.StringUtils.trim((String)entity.getName()));
        entity.setNickName(org.apache.commons.lang3.StringUtils.trim((String)entity.getNickName()));
        entity.setPassword(org.apache.commons.lang3.StringUtils.trim((String)entity.getPassword()));
        repassword = org.apache.commons.lang3.StringUtils.trim((String)repassword);
        if (ControllerUtils.verifyNotEmpty("username", entity.getName(), (Map<String, Object>)model) || ControllerUtils.verifyNotEmpty("nickname", entity.getNickName(), (Map<String, Object>)model) || SysUserAdminController.verifyNotUserName("username", entity.getName(), (Map<String, Object>)model) || SysUserAdminController.verifyNotNickName("nickname", entity.getNickName(), (Map<String, Object>)model)) {
            return "common/ajaxError";
        }
        if (entity.isSuperuserAccess()) {
            entity.setRoles(StringUtils.arrayToCommaDelimitedString((Object[])roleIds));
        } else {
            roleIds = null;
            entity.setRoles(null);
            entity.setDeptId(null);
        }
        if (null != entity.getId()) {
            SysUser oldEntity = (SysUser)this.service.getEntity(entity.getId());
            if (null == oldEntity || ControllerUtils.verifyNotEquals("siteId", site.getId(), oldEntity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            SysUser user = (SysUser)this.service.getEntity(entity.getId());
            if (!user.getName().equals(entity.getName()) && ControllerUtils.verifyHasExist("username", this.service.findByName(site.getId(), entity.getName()), (Map<String, Object>)model) || !user.getNickName().equals(entity.getNickName()) && ControllerUtils.verifyHasExist("nickname", this.service.findByNickName(site.getId(), entity.getNickName()), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            if (CommonUtils.notEmpty(entity.getPassword())) {
                if (ControllerUtils.verifyNotEquals("repassword", entity.getPassword(), repassword, (Map<String, Object>)model)) {
                    return "common/ajaxError";
                }
                entity.setPassword(VerificationUtils.encode(entity.getPassword()));
            } else {
                entity.setPassword(user.getPassword());
                if (CommonUtils.empty(entity.getEmail()) || !entity.getEmail().equals(user.getEmail())) {
                    entity.setEmailChecked(false);
                }
            }
            entity = this.service.update(entity.getId(), entity, this.ignoreProperties);
            if (null != entity) {
                this.roleUserService.dealRoleUsers(entity.getId(), roleIds);
                this.logOperateService.save(new LogOperate(site.getId(), SysUserAdminController.getAdminFromSession(session).getId(), "web_manager", "update.user", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
            }
        } else {
            if (ControllerUtils.verifyNotEmpty("password", entity.getPassword(), (Map<String, Object>)model) || ControllerUtils.verifyNotEquals("repassword", entity.getPassword(), repassword, (Map<String, Object>)model) || ControllerUtils.verifyHasExist("username", this.service.findByName(site.getId(), entity.getName()), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            entity.setSiteId(site.getId());
            entity.setPassword(VerificationUtils.encode(entity.getPassword()));
            this.service.save(entity);
            if (CommonUtils.notEmpty(roleIds)) {
                for (Integer roleId : roleIds) {
                    this.roleUserService.save(new SysRoleUser(new SysRoleUserId(roleId, entity.getId())));
                }
            }
            this.logOperateService.save(new LogOperate(site.getId(), SysUserAdminController.getAdminFromSession(session).getId(), "web_manager", "save.user", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"enable"}, method={RequestMethod.POST})
    public String enable(Long id, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (ControllerUtils.verifyEquals("admin.operate", SysUserAdminController.getAdminFromSession(session).getId(), id, model)) {
            return "common/ajaxError";
        }
        SysUser entity = (SysUser)this.service.getEntity(id);
        if (null != entity) {
            SysSite site = this.getSite(request);
            if (ControllerUtils.verifyNotEquals("siteId", site.getId(), entity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            this.service.updateStatus(id, false);
            this.logOperateService.save(new LogOperate(site.getId(), SysUserAdminController.getAdminFromSession(session).getId(), "web_manager", "enable.user", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"disable"}, method={RequestMethod.POST})
    public String disable(Long id, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (ControllerUtils.verifyEquals("admin.operate", SysUserAdminController.getAdminFromSession(session).getId(), id, model)) {
            return "common/ajaxError";
        }
        SysUser entity = (SysUser)this.service.getEntity(id);
        if (null != entity) {
            SysSite site = this.getSite(request);
            if (ControllerUtils.verifyNotEquals("siteId", site.getId(), entity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            this.service.updateStatus(id, true);
            this.logOperateService.save(new LogOperate(site.getId(), SysUserAdminController.getAdminFromSession(session).getId(), "web_manager", "disable.user", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }
}

