/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.sys;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.ControllerUtils;
import com.publiccms.common.tools.JsonUtils;
import com.publiccms.common.tools.RequestUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.publiccms.common.base.AbstractController;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.entities.sys.SysTask;
import org.publiccms.logic.component.task.ScheduledTask;
import org.publiccms.logic.service.sys.SysTaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"sysTask"})
public class SysTaskAdminController
extends AbstractController {
    @Autowired
    private SysTaskService service;
    @Autowired
    private ScheduledTask scheduledTask;
    private String[] ignoreProperties = new String[]{"id", "siteId"};

    @RequestMapping(value={"save"})
    public String save(SysTask entity, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        if (null != entity.getId()) {
            SysTask oldEntity = (SysTask)this.service.getEntity(entity.getId());
            if (null == oldEntity || ControllerUtils.verifyNotEquals("siteId", site.getId(), oldEntity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            entity.setUpdateDate(CommonUtils.getDate());
            entity = this.service.update(entity.getId(), entity, this.ignoreProperties);
            if (null != entity) {
                this.logOperateService.save(new LogOperate(site.getId(), SysTaskAdminController.getAdminFromSession(session).getId(), "web_manager", "update.task", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
            }
        } else {
            entity.setSiteId(site.getId());
            this.service.save(entity);
            this.logOperateService.save(new LogOperate(site.getId(), SysTaskAdminController.getAdminFromSession(session).getId(), "web_manager", "save.task", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        this.scheduledTask.create(site, entity.getId(), entity.getCronExpression());
        return "common/ajaxDone";
    }

    @RequestMapping(value={"runOnce"})
    public String runOnce(Integer id, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        SysTask entity = (SysTask)this.service.getEntity(id);
        if (null != entity) {
            if (ControllerUtils.verifyNotEquals("siteId", site.getId(), entity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            this.scheduledTask.runOnce(site, id);
            this.logOperateService.save(new LogOperate(site.getId(), SysTaskAdminController.getAdminFromSession(session).getId(), "web_manager", "runOnce.task", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"pause"})
    public String pause(Integer id, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        SysTask entity = (SysTask)this.service.getEntity(id);
        if (null != entity) {
            if (ControllerUtils.verifyNotEquals("siteId", site.getId(), entity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            this.service.updateStatus(id, 2);
            this.scheduledTask.pause(site, id);
            this.logOperateService.save(new LogOperate(site.getId(), SysTaskAdminController.getAdminFromSession(session).getId(), "web_manager", "pause.task", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"resume"})
    public String resume(Integer id, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        SysTask entity = (SysTask)this.service.getEntity(id);
        if (null != entity) {
            if (ControllerUtils.verifyNotEquals("siteId", site.getId(), entity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            this.service.updateStatus(id, 0);
            this.scheduledTask.resume(site, id);
            this.logOperateService.save(new LogOperate(site.getId(), SysTaskAdminController.getAdminFromSession(session).getId(), "web_manager", "resume.task", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"recreate"})
    public String recreate(Integer id, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        SysTask entity = (SysTask)this.service.getEntity(id);
        if (null != entity) {
            if (ControllerUtils.verifyNotEquals("siteId", site.getId(), entity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            this.service.updateStatus(id, 0);
            this.scheduledTask.create(site, entity.getId(), entity.getCronExpression());
            this.logOperateService.save(new LogOperate(site.getId(), SysTaskAdminController.getAdminFromSession(session).getId(), "web_manager", "update.task", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"delete"})
    public String delete(Integer id, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        SysTask entity = (SysTask)this.service.getEntity(id);
        if (null != entity) {
            if (ControllerUtils.verifyNotEquals("siteId", site.getId(), entity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            this.service.delete(id);
            this.scheduledTask.delete(id);
            this.logOperateService.save(new LogOperate(site.getId(), SysTaskAdminController.getAdminFromSession(session).getId(), "web_manager", "delete.task", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }
}

