/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.sys;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.ControllerUtils;
import com.publiccms.common.tools.JsonUtils;
import com.publiccms.common.tools.RequestUtils;
import com.publiccms.common.tools.VerificationUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.publiccms.common.base.AbstractController;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysDept;
import org.publiccms.entities.sys.SysDomain;
import org.publiccms.entities.sys.SysRole;
import org.publiccms.entities.sys.SysRoleUser;
import org.publiccms.entities.sys.SysRoleUserId;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.entities.sys.SysUser;
import org.publiccms.logic.service.cms.CmsContentService;
import org.publiccms.logic.service.sys.SysDeptService;
import org.publiccms.logic.service.sys.SysDomainService;
import org.publiccms.logic.service.sys.SysRoleService;
import org.publiccms.logic.service.sys.SysRoleUserService;
import org.publiccms.logic.service.sys.SysSiteService;
import org.publiccms.logic.service.sys.SysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"sysSite"})
public class SysSiteAdminController
extends AbstractController {
    @Autowired
    private SysSiteService service;
    @Autowired
    private SysRoleService roleService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private SysDeptService deptService;
    @Autowired
    private SysRoleUserService roleUserService;
    @Autowired
    private SysDomainService domainService;
    @Autowired
    private CmsContentService contentService;
    private String[] ignoreProperties = new String[]{"id"};

    @RequestMapping(value={"save"})
    public String save(SysSite entity, String domainName, String roleName, String deptName, String userName, String password, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        if (ControllerUtils.verifyCustom("noright", !this.siteComponent.isMaster(site.getId()), (Map<String, Object>)model)) {
            return "common/ajaxError";
        }
        if (!entity.isUseStatic()) {
            entity.setUseSsi(false);
        }
        if (null != entity.getId()) {
            if (null != (entity = this.service.update(entity.getId(), entity, this.ignoreProperties))) {
                this.logOperateService.save(new LogOperate(site.getId(), SysSiteAdminController.getAdminFromSession(session).getId(), "web_manager", "update.site", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
            }
        } else {
            if (ControllerUtils.verifyNotEmpty("userName", userName, (Map<String, Object>)model) || ControllerUtils.verifyNotEmpty("password", password, (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            this.service.save(entity);
            SysDomain domain = new SysDomain(domainName, entity.getId(), false);
            this.domainService.save(domain);
            SysDept dept = new SysDept(entity.getId(), deptName, 0, true, true);
            this.deptService.save(dept);
            SysRole role = new SysRole(entity.getId(), roleName, true, true);
            this.roleService.save(role);
            SysUser user = new SysUser(entity.getId(), userName, VerificationUtils.encode(password), userName, dept.getId(), role.getId().toString(), null, false, true, false, null, null, 0, CommonUtils.getDate());
            this.userService.save(user);
            this.roleUserService.save(new SysRoleUser(new SysRoleUserId(role.getId(), user.getId())));
            this.logOperateService.save(new LogOperate(site.getId(), SysSiteAdminController.getAdminFromSession(session).getId(), "web_manager", "save.site", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        this.siteComponent.clear();
        return "common/ajaxDone";
    }

    @RequestMapping(value={"delete"})
    public String delete(Integer id, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        if (ControllerUtils.verifyCustom("noright", !this.siteComponent.isMaster(site.getId()), (Map<String, Object>)model)) {
            return "common/ajaxError";
        }
        SysSite entity = (SysSite)this.service.getEntity(id);
        if (null != entity) {
            this.service.delete(id);
            Long userId = SysSiteAdminController.getAdminFromSession(session).getId();
            Date now = CommonUtils.getDate();
            String ip = RequestUtils.getIpAddress(request);
            for (SysDomain domain : this.domainService.getPage(entity.getId(), null, null, null).getList()) {
                this.domainService.delete((Serializable)((Object)domain.getName()));
                this.logOperateService.save(new LogOperate(site.getId(), userId, "web_manager", "delete.domain", ip, now, JsonUtils.getString(entity)));
            }
            this.logOperateService.save(new LogOperate(site.getId(), userId, "web_manager", "delete.site", ip, now, JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"reCreateIndex"})
    public String reCreateIndex(HttpServletRequest request, HttpSession session) {
        this.contentService.reCreateIndex();
        SysSite site = this.getSite(request);
        Long userId = SysSiteAdminController.getAdminFromSession(session).getId();
        this.logOperateService.save(new LogOperate(site.getId(), userId, "web_manager", "delete.site", RequestUtils.getIpAddress(request), CommonUtils.getDate(), ""));
        return "common/ajaxDone";
    }
}

