/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.sys;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.ControllerUtils;
import com.publiccms.common.tools.JsonUtils;
import com.publiccms.common.tools.RequestUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.publiccms.common.base.AbstractController;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysRole;
import org.publiccms.entities.sys.SysRoleMoudle;
import org.publiccms.entities.sys.SysRoleMoudleId;
import org.publiccms.entities.sys.SysRoleUser;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.service.sys.SysMoudleService;
import org.publiccms.logic.service.sys.SysRoleAuthorizedService;
import org.publiccms.logic.service.sys.SysRoleMoudleService;
import org.publiccms.logic.service.sys.SysRoleService;
import org.publiccms.logic.service.sys.SysRoleUserService;
import org.publiccms.logic.service.sys.SysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"sysRole"})
public class SysRoleAdminController
extends AbstractController {
    @Autowired
    private SysRoleService service;
    @Autowired
    private SysRoleUserService roleUserService;
    @Autowired
    private SysRoleMoudleService roleMoudleService;
    @Autowired
    private SysMoudleService moudleService;
    @Autowired
    private SysRoleAuthorizedService roleAuthorizedService;
    @Autowired
    private SysUserService userService;
    private String[] ignoreProperties = new String[]{"id", "siteId"};

    @RequestMapping(value={"save"})
    public String save(SysRole entity, Integer[] moudleIds, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        if (entity.isOwnsAllRight()) {
            moudleIds = null;
            entity.setShowAllMoudle(false);
        }
        if (null != entity.getId()) {
            SysRole oldEntity = (SysRole)this.service.getEntity(entity.getId());
            if (null == oldEntity || ControllerUtils.verifyNotEquals("siteId", site.getId(), oldEntity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            entity = this.service.update(entity.getId(), entity, this.ignoreProperties);
            this.roleMoudleService.updateRoleMoudles(entity.getId(), moudleIds);
            if (null != entity) {
                this.logOperateService.save(new LogOperate(site.getId(), SysRoleAdminController.getAdminFromSession(session).getId(), "web_manager", "update.role", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
            }
        } else {
            entity.setSiteId(site.getId());
            this.service.save(entity);
            if (CommonUtils.notEmpty(moudleIds)) {
                ArrayList<SysRoleMoudle> list = new ArrayList<SysRoleMoudle>();
                Integer[] integerArray = moudleIds;
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int moudleId = integerArray[i];
                    list.add(new SysRoleMoudle(new SysRoleMoudleId(entity.getId(), moudleId)));
                }
                this.roleMoudleService.save(list);
            }
            this.logOperateService.save(new LogOperate(site.getId(), SysRoleAdminController.getAdminFromSession(session).getId(), "web_manager", "save.role", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        this.roleAuthorizedService.dealRoleMoudles(entity.getId(), entity.isShowAllMoudle(), this.moudleService.getEntitys(moudleIds), this.moudleService.getPageUrl(null));
        return "common/ajaxDone";
    }

    @RequestMapping(value={"delete"})
    public String delete(Integer id, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysRole entity = (SysRole)this.service.getEntity(id);
        SysSite site = this.getSite(request);
        if (null != entity) {
            if (ControllerUtils.verifyNotEquals("siteId", site.getId(), entity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            this.service.delete(id);
            List<?> roleUserList = this.roleUserService.getPage(id, null, null, null).getList();
            for (SysRoleUser roleUser : roleUserList) {
                this.userService.deleteRoleIds(Long.valueOf(roleUser.getId().getUserId()), id);
            }
            this.roleUserService.deleteByRoleId(id);
            this.roleMoudleService.deleteByRoleId(id);
            this.roleAuthorizedService.deleteByRoleId(id);
            this.logOperateService.save(new LogOperate(site.getId(), SysRoleAdminController.getAdminFromSession(session).getId(), "web_manager", "delete.role", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }
}

