/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.sys;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.ControllerUtils;
import com.publiccms.common.tools.JsonUtils;
import com.publiccms.common.tools.RequestUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.publiccms.common.base.AbstractController;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysMoudle;
import org.publiccms.entities.sys.SysRole;
import org.publiccms.entities.sys.SysRoleMoudle;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.service.sys.SysMoudleService;
import org.publiccms.logic.service.sys.SysRoleAuthorizedService;
import org.publiccms.logic.service.sys.SysRoleMoudleService;
import org.publiccms.logic.service.sys.SysRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"sysMoudle"})
public class SysMoudleAdminController
extends AbstractController {
    @Autowired
    private SysMoudleService service;
    @Autowired
    private SysRoleService roleService;
    @Autowired
    private SysMoudleService moudleService;
    @Autowired
    private SysRoleMoudleService roleMoudleService;
    @Autowired
    private SysRoleAuthorizedService roleAuthorizedService;
    private String[] ignoreProperties = new String[]{"id"};

    @RequestMapping(value={"save"})
    public String save(SysMoudle entity, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        if (ControllerUtils.verifyCustom("noright", !this.siteComponent.isMaster(site.getId()), (Map<String, Object>)model)) {
            return "common/ajaxError";
        }
        if (null != entity.getId()) {
            if (null != (entity = this.service.update(entity.getId(), entity, this.ignoreProperties))) {
                List<SysRoleMoudle> roleMoudleList = this.roleMoudleService.getPage(null, entity.getId(), null, null).getList();
                this.dealRoleAuthorized(roleMoudleList);
                this.logOperateService.save(new LogOperate(site.getId(), SysMoudleAdminController.getAdminFromSession(session).getId(), "web_manager", "update.moudle", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
            }
        } else {
            this.service.save(entity);
            this.logOperateService.save(new LogOperate(site.getId(), SysMoudleAdminController.getAdminFromSession(session).getId(), "web_manager", "save.moudle", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"delete"})
    public String delete(Integer id, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        if (ControllerUtils.verifyCustom("noright", !this.siteComponent.isMaster(site.getId()), (Map<String, Object>)model)) {
            return "common/ajaxError";
        }
        SysMoudle entity = (SysMoudle)this.service.getEntity(id);
        if (null != entity) {
            this.service.delete(id);
            List<SysRoleMoudle> roleMoudleList = this.roleMoudleService.getPage(null, id, null, null).getList();
            this.roleMoudleService.deleteByMoudleId(id);
            this.dealRoleAuthorized(roleMoudleList);
            this.logOperateService.save(new LogOperate(this.getSite(request).getId(), SysMoudleAdminController.getAdminFromSession(session).getId(), "web_manager", "delete.moudle", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }

    private void dealRoleAuthorized(List<SysRoleMoudle> roleMoudleList) {
        Set<String> pageUrls = this.moudleService.getPageUrl(null);
        for (SysRoleMoudle roleMoudle : roleMoudleList) {
            HashSet<Integer> moudleIds = new HashSet<Integer>();
            for (SysRoleMoudle roleMoudle2 : this.roleMoudleService.getPage(roleMoudle.getId().getRoleId(), null, null, null).getList()) {
                moudleIds.add(roleMoudle2.getId().getMoudleId());
            }
            SysRole role = (SysRole)this.roleService.getEntity(Integer.valueOf(roleMoudle.getId().getRoleId()));
            if (moudleIds.isEmpty() || null == role || role.isOwnsAllRight()) continue;
            this.roleAuthorizedService.dealRoleMoudles(roleMoudle.getId().getRoleId(), role.isShowAllMoudle(), this.service.getEntitys(moudleIds.toArray(new Integer[moudleIds.size()])), pageUrls);
        }
    }
}

