/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.sys;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.ControllerUtils;
import com.publiccms.common.tools.JsonUtils;
import com.publiccms.common.tools.RequestUtils;
import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.publiccms.common.base.AbstractController;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysDomain;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.service.sys.SysDomainService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"sysDomain"})
public class SysDomainAdminController
extends AbstractController {
    @Autowired
    private SysDomainService service;
    private String[] ignoreProperties = new String[]{"siteId", "name", "wild"};

    @RequestMapping(value={"save"})
    public String save(SysDomain entity, String id, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        if (ControllerUtils.verifyCustom("noright", !this.siteComponent.isMaster(site.getId()), (Map<String, Object>)model)) {
            return "common/ajaxError";
        }
        if (CommonUtils.notEmpty(id)) {
            if (!entity.getName().equals(id) && ControllerUtils.verifyHasExist("domain", this.service.getEntity((Serializable)((Object)entity.getName())), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            if (null != (entity = this.service.update((Serializable)((Object)id), entity))) {
                this.logOperateService.save(new LogOperate(site.getId(), SysDomainAdminController.getAdminFromSession(session).getId(), "web_manager", "update.domain", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
            }
        } else {
            if (ControllerUtils.verifyHasExist("domain", this.service.getEntity((Serializable)((Object)entity.getName())), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            if (0 == entity.getSiteId()) {
                entity.setSiteId(site.getId());
            }
            this.service.save(entity);
            this.logOperateService.save(new LogOperate(site.getId(), SysDomainAdminController.getAdminFromSession(session).getId(), "web_manager", "save.domain", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        this.siteComponent.clear();
        return "common/ajaxDone";
    }

    @RequestMapping(value={"saveConfig"})
    public String saveConfig(SysDomain entity, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (CommonUtils.notEmpty(entity.getName())) {
            SysSite site = this.getSite(request);
            SysDomain oldEntity = (SysDomain)this.service.getEntity((Serializable)((Object)entity.getName()));
            if (null == oldEntity || ControllerUtils.verifyNotEquals("siteId", site.getId(), oldEntity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            if (null != (entity = this.service.update((Serializable)((Object)entity.getName()), entity, this.ignoreProperties))) {
                this.logOperateService.save(new LogOperate(site.getId(), SysDomainAdminController.getAdminFromSession(session).getId(), "web_manager", "update.domain", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
            }
            this.siteComponent.clear();
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"virify"})
    @ResponseBody
    public boolean virify(String name, String domainName, String id, ModelMap model) {
        if (CommonUtils.notEmpty(name) && (CommonUtils.notEmpty(id) && !name.equals(((SysDomain)this.service.getEntity((Serializable)((Object)id))).getName()) && ControllerUtils.verifyHasExist("domain", this.service.getEntity((Serializable)((Object)name)), (Map<String, Object>)model) || CommonUtils.empty(id) && ControllerUtils.verifyHasExist("domain", this.service.getEntity((Serializable)((Object)name)), (Map<String, Object>)model))) {
            return false;
        }
        return !CommonUtils.notEmpty(domainName) || (!CommonUtils.notEmpty(id) || domainName.equals(((SysDomain)this.service.getEntity((Serializable)((Object)id))).getName()) || !ControllerUtils.verifyHasExist("domain", this.service.getEntity((Serializable)((Object)domainName)), (Map<String, Object>)model)) && (!CommonUtils.empty(id) || !ControllerUtils.verifyHasExist("domain", this.service.getEntity((Serializable)((Object)domainName)), (Map<String, Object>)model));
    }

    @RequestMapping(value={"delete"})
    public String delete(String id, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        if (ControllerUtils.verifyCustom("noright", !this.siteComponent.isMaster(site.getId()), (Map<String, Object>)model)) {
            return "common/ajaxError";
        }
        SysDomain entity = (SysDomain)this.service.getEntity((Serializable)((Object)id));
        if (null != entity) {
            this.service.delete((Serializable)((Object)id));
            this.logOperateService.save(new LogOperate(site.getId(), SysDomainAdminController.getAdminFromSession(session).getId(), "web_manager", "delete.domain", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        this.siteComponent.clear();
        return "common/ajaxDone";
    }
}

