/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.sys;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.ControllerUtils;
import com.publiccms.common.tools.JsonUtils;
import com.publiccms.common.tools.RequestUtils;
import com.publiccms.common.tools.VerificationUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.publiccms.common.base.AbstractController;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysDept;
import org.publiccms.entities.sys.SysDeptCategory;
import org.publiccms.entities.sys.SysDeptCategoryId;
import org.publiccms.entities.sys.SysDeptPage;
import org.publiccms.entities.sys.SysDeptPageId;
import org.publiccms.entities.sys.SysRoleUser;
import org.publiccms.entities.sys.SysRoleUserId;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.entities.sys.SysUser;
import org.publiccms.logic.service.sys.SysDeptCategoryService;
import org.publiccms.logic.service.sys.SysDeptPageService;
import org.publiccms.logic.service.sys.SysDeptService;
import org.publiccms.logic.service.sys.SysRoleUserService;
import org.publiccms.logic.service.sys.SysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"sysDept"})
public class SysDeptAdminController
extends AbstractController {
    @Autowired
    private SysDeptService service;
    @Autowired
    private SysUserService userService;
    @Autowired
    private SysRoleUserService roleUserService;
    @Autowired
    private SysDeptCategoryService sysDeptCategoryService;
    @Autowired
    private SysDeptPageService sysDeptPageService;
    private String[] ignoreProperties = new String[]{"id", "siteId"};
    private String[] userIgnoreProperties = new String[]{"id", "superuserAccess", "registeredDate", "siteId", "authToken", "lastLoginDate", "lastLoginIp", "loginCount", "disabled"};

    @RequestMapping(value={"save"})
    public String save(SysDept entity, Integer[] categoryIds, String[] pages, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        if (null != entity.getId()) {
            SysDept oldEntity = (SysDept)this.service.getEntity(entity.getId());
            if (null == oldEntity || ControllerUtils.verifyNotEquals("siteId", site.getId(), oldEntity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            if (null != (entity = this.service.update(entity.getId(), entity, this.ignoreProperties))) {
                this.logOperateService.save(new LogOperate(site.getId(), SysDeptAdminController.getAdminFromSession(session).getId(), "web_manager", "update.dept", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
            }
            this.sysDeptCategoryService.updateDeptCategorys(entity.getId(), categoryIds);
            this.sysDeptPageService.updateDeptPages(entity.getId(), pages);
        } else {
            ArrayList<Serializable> list;
            entity.setSiteId(site.getId());
            this.service.save(entity);
            this.logOperateService.save(new LogOperate(site.getId(), SysDeptAdminController.getAdminFromSession(session).getId(), "web_manager", "save.dept", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
            if (CommonUtils.notEmpty(categoryIds)) {
                list = new ArrayList<Serializable>();
                Object[] objectArray = categoryIds;
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    int categoryId = (Integer)objectArray[i];
                    list.add(new SysDeptCategory(new SysDeptCategoryId(entity.getId(), categoryId)));
                }
                this.sysDeptCategoryService.save(list);
            }
            if (CommonUtils.notEmpty(pages)) {
                list = new ArrayList();
                for (String page : pages) {
                    list.add(new SysDeptPage(new SysDeptPageId(entity.getId(), page)));
                }
                this.sysDeptPageService.save(list);
            }
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"saveUser"})
    public String saveUser(SysUser entity, String repassword, Integer[] roleIds, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        entity.setName(org.apache.commons.lang3.StringUtils.trim((String)entity.getName()));
        entity.setNickName(org.apache.commons.lang3.StringUtils.trim((String)entity.getNickName()));
        entity.setPassword(org.apache.commons.lang3.StringUtils.trim((String)entity.getPassword()));
        repassword = org.apache.commons.lang3.StringUtils.trim((String)repassword);
        SysDept dept = (SysDept)this.service.getEntity(entity.getDeptId());
        SysUser admin = SysDeptAdminController.getAdminFromSession(session);
        if (ControllerUtils.verifyNotEmpty("username", entity.getName(), (Map<String, Object>)model) || ControllerUtils.verifyNotEmpty("deptId", dept, (Map<String, Object>)model) || ControllerUtils.verifyNotEquals("userId", dept.getUserId(), admin.getId(), (Map<String, Object>)model) || ControllerUtils.verifyNotEquals("siteId", site.getId(), dept.getSiteId(), (Map<String, Object>)model) || ControllerUtils.verifyNotEmpty("nickname", entity.getNickName(), (Map<String, Object>)model) || SysDeptAdminController.verifyNotUserName("username", entity.getName(), (Map<String, Object>)model) || SysDeptAdminController.verifyNotNickName("nickname", entity.getNickName(), (Map<String, Object>)model)) {
            return "common/ajaxError";
        }
        entity.setSuperuserAccess(true);
        entity.setRoles(StringUtils.arrayToCommaDelimitedString((Object[])roleIds));
        if (null != entity.getId()) {
            SysUser oldEntity = (SysUser)this.userService.getEntity(entity.getId());
            if (null == oldEntity || ControllerUtils.verifyNotEquals("siteId", site.getId(), oldEntity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            SysUser user = (SysUser)this.userService.getEntity(entity.getId());
            if (!user.getName().equals(entity.getName()) && ControllerUtils.verifyHasExist("username", this.userService.findByName(site.getId(), entity.getName()), (Map<String, Object>)model) || !user.getNickName().equals(entity.getNickName()) && ControllerUtils.verifyHasExist("nickname", this.userService.findByNickName(site.getId(), entity.getNickName()), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            if (CommonUtils.notEmpty(entity.getPassword())) {
                if (ControllerUtils.verifyNotEquals("repassword", entity.getPassword(), repassword, (Map<String, Object>)model)) {
                    return "common/ajaxError";
                }
                entity.setPassword(VerificationUtils.encode(entity.getPassword()));
            } else {
                entity.setPassword(user.getPassword());
                if (CommonUtils.empty(entity.getEmail()) || !entity.getEmail().equals(user.getEmail())) {
                    entity.setEmailChecked(false);
                }
            }
            entity = this.userService.update(entity.getId(), entity, this.userIgnoreProperties);
            if (null != entity) {
                this.roleUserService.dealRoleUsers(entity.getId(), roleIds);
                this.logOperateService.save(new LogOperate(site.getId(), admin.getId(), "web_manager", "update.user", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
            }
        } else {
            if (ControllerUtils.verifyNotEmpty("password", entity.getPassword(), (Map<String, Object>)model) || ControllerUtils.verifyNotEquals("repassword", entity.getPassword(), repassword, (Map<String, Object>)model) || ControllerUtils.verifyHasExist("username", this.userService.findByName(site.getId(), entity.getName()), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            entity.setDeptId(dept.getId());
            entity.setSiteId(site.getId());
            entity.setPassword(VerificationUtils.encode(entity.getPassword()));
            this.userService.save(entity);
            if (CommonUtils.notEmpty(roleIds)) {
                for (Integer roleId : roleIds) {
                    this.roleUserService.save(new SysRoleUser(new SysRoleUserId(roleId, entity.getId())));
                }
            }
            this.logOperateService.save(new LogOperate(site.getId(), admin.getId(), "web_manager", "save.user", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"delete"})
    public String delete(Integer id, HttpServletRequest request, HttpSession session) {
        SysSite site = this.getSite(request);
        List<Integer> list = this.service.delete(site.getId(), id);
        if (0 < list.size()) {
            for (Integer childId : list) {
                this.sysDeptCategoryService.delete(childId, null);
                this.sysDeptPageService.delete(childId, null);
            }
            this.logOperateService.save(new LogOperate(site.getId(), SysDeptAdminController.getAdminFromSession(session).getId(), "web_manager", "delete.dept", RequestUtils.getIpAddress(request), CommonUtils.getDate(), id.toString()));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"enableUser"}, method={RequestMethod.POST})
    public String enable(Long id, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (ControllerUtils.verifyEquals("admin.operate", SysDeptAdminController.getAdminFromSession(session).getId(), id, model)) {
            return "common/ajaxError";
        }
        SysUser entity = (SysUser)this.userService.getEntity(id);
        if (null != entity) {
            SysSite site = this.getSite(request);
            SysDept dept = (SysDept)this.service.getEntity(entity.getDeptId());
            SysUser admin = SysDeptAdminController.getAdminFromSession(session);
            if (ControllerUtils.verifyNotEquals("siteId", site.getId(), entity.getSiteId(), (Map<String, Object>)model) || ControllerUtils.verifyNotEmpty("deptId", dept, (Map<String, Object>)model) || ControllerUtils.verifyNotEquals("userId", dept.getUserId(), admin.getId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            this.userService.updateStatus(id, false);
            this.logOperateService.save(new LogOperate(site.getId(), admin.getId(), "web_manager", "enable.user", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"disableUser"}, method={RequestMethod.POST})
    public String disable(Long id, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (ControllerUtils.verifyEquals("admin.operate", SysDeptAdminController.getAdminFromSession(session).getId(), id, model)) {
            return "common/ajaxError";
        }
        SysUser entity = (SysUser)this.userService.getEntity(id);
        if (null != entity) {
            SysSite site = this.getSite(request);
            SysDept dept = (SysDept)this.service.getEntity(entity.getDeptId());
            SysUser admin = SysDeptAdminController.getAdminFromSession(session);
            if (ControllerUtils.verifyNotEquals("siteId", site.getId(), entity.getSiteId(), (Map<String, Object>)model) || ControllerUtils.verifyNotEmpty("deptId", dept, (Map<String, Object>)model) || ControllerUtils.verifyNotEquals("userId", dept.getUserId(), admin.getId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            this.userService.updateStatus(id, true);
            this.logOperateService.save(new LogOperate(site.getId(), admin.getId(), "web_manager", "disable.user", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }
}

