/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.sys;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.ControllerUtils;
import com.publiccms.common.tools.JsonUtils;
import com.publiccms.common.tools.RequestUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.publiccms.common.base.AbstractController;
import org.publiccms.common.tools.ExtendUtils;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysConfigData;
import org.publiccms.entities.sys.SysConfigDataId;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.config.ConfigComponent;
import org.publiccms.logic.service.sys.SysConfigDataService;
import org.publiccms.views.pojo.SysConfigParamters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.support.RequestContextUtils;

@Controller
@RequestMapping(value={"sysConfigData"})
public class SysConfigDataAdminController
extends AbstractController {
    private String[] ignoreProperties = new String[]{"id"};
    @Autowired
    private ConfigComponent configComponent;
    @Autowired
    private SysConfigDataService service;

    @RequestMapping(value={"save"})
    public String save(SysConfigData entity, @ModelAttribute SysConfigParamters sysConfigParamters, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        if (null != entity.getId()) {
            entity.getId().setSiteId(site.getId());
            SysConfigData oldEntity = (SysConfigData)this.service.getEntity(entity.getId());
            if (null != oldEntity && ControllerUtils.verifyNotEquals("siteId", site.getId(), oldEntity.getId().getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            Map<String, String> map = ExtendUtils.getExtentDataMap(sysConfigParamters.getExtendDataList(), this.configComponent.getFieldList(site, entity.getId().getCode(), null, RequestContextUtils.getLocale((HttpServletRequest)request)));
            entity.setData(ExtendUtils.getExtendString(map));
            if (null != oldEntity) {
                entity = this.service.update(oldEntity.getId(), entity, this.ignoreProperties);
                if (null != entity) {
                    this.logOperateService.save(new LogOperate(site.getId(), SysConfigDataAdminController.getAdminFromSession(session).getId(), "web_manager", "update.configData", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
                    this.configComponent.removeCache(site.getId(), entity.getId().getCode());
                }
            } else {
                entity.getId().setSiteId(site.getId());
                this.service.save(entity);
                this.logOperateService.save(new LogOperate(site.getId(), SysConfigDataAdminController.getAdminFromSession(session).getId(), "web_manager", "save.configData", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
                this.configComponent.removeCache(site.getId(), entity.getId().getCode());
            }
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"delete"})
    public String delete(String code, HttpServletRequest request, HttpSession session) {
        SysSite site = this.getSite(request);
        SysConfigData entity = (SysConfigData)this.service.getEntity(new SysConfigDataId(site.getId(), code));
        if (null != entity) {
            this.service.delete(entity.getId());
            this.logOperateService.save(new LogOperate(site.getId(), SysConfigDataAdminController.getAdminFromSession(session).getId(), "web_manager", "delete.configData", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
            this.configComponent.removeCache(site.getId(), entity.getId().getCode());
        }
        return "common/ajaxDone";
    }
}

