/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.sys;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.JsonUtils;
import com.publiccms.common.tools.RequestUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.publiccms.common.base.AbstractController;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.config.ConfigComponent;
import org.publiccms.views.pojo.SysConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"sysConfig"})
public class SysConfigAdminController
extends AbstractController {
    @Autowired
    private ConfigComponent configComponent;

    @RequestMapping(value={"save"})
    public String save(@ModelAttribute SysConfig entity, String configCode, HttpServletRequest request, HttpSession session) {
        SysSite site = this.getSite(request);
        if (CommonUtils.notEmpty(configCode)) {
            Map<String, SysConfig> map = this.configComponent.getMap(site);
            map.remove(configCode);
            map.put(entity.getCode(), entity);
            this.configComponent.save(site, map);
            this.logOperateService.save(new LogOperate(site.getId(), SysConfigAdminController.getAdminFromSession(session).getId(), "web_manager", "update.config", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        } else {
            Map<String, SysConfig> map = this.configComponent.getMap(site);
            map.put(entity.getCode(), entity);
            this.configComponent.save(site, map);
            this.logOperateService.save(new LogOperate(site.getId(), SysConfigAdminController.getAdminFromSession(session).getId(), "web_manager", "save.config", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"delete"})
    public String delete(String code, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        Map<String, SysConfig> modelMap = this.configComponent.getMap(site);
        SysConfig entity = modelMap.remove(code);
        if (null != entity) {
            this.configComponent.save(site, modelMap);
            this.logOperateService.save(new LogOperate(site.getId(), SysConfigAdminController.getAdminFromSession(session).getId(), "web_manager", "delete.config", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }
}

