/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.sys;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.ControllerUtils;
import com.publiccms.common.tools.JsonUtils;
import com.publiccms.common.tools.RequestUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.publiccms.common.base.AbstractController;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysApp;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.service.sys.SysAppService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"sysApp"})
public class SysAppAdminController
extends AbstractController {
    @Autowired
    private SysAppService service;
    private String[] ignoreProperties = new String[]{"id", "siteId", "channel"};

    @RequestMapping(value={"save"})
    public String save(SysApp entity, String[] apis, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        entity.setAuthorizedApis(StringUtils.arrayToCommaDelimitedString((Object[])apis));
        if (null != entity.getId()) {
            SysApp oldEntity = (SysApp)this.service.getEntity(entity.getId());
            if (null == oldEntity || ControllerUtils.verifyNotEquals("siteId", site.getId(), oldEntity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            if (null != (entity = this.service.update(entity.getId(), entity, this.ignoreProperties))) {
                entity.setAppSecret(null);
                this.logOperateService.save(new LogOperate(site.getId(), SysAppAdminController.getAdminFromSession(session).getId(), "web_manager", "update.app", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
            }
        } else {
            entity.setSiteId(site.getId());
            this.service.save(entity);
            entity.setAppSecret(null);
            this.logOperateService.save(new LogOperate(site.getId(), SysAppAdminController.getAdminFromSession(session).getId(), "web_manager", "save.app", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"delete"})
    public String delete(Integer id, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        SysApp entity = (SysApp)this.service.getEntity(id);
        if (null != entity) {
            if (ControllerUtils.verifyNotEquals("siteId", site.getId(), entity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            this.service.delete(id);
            entity.setAppSecret(null);
            this.logOperateService.save(new LogOperate(site.getId(), SysAppAdminController.getAdminFromSession(session).getId(), "web_manager", "delete.app", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }
}

