/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.sys;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.RequestUtils;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.publiccms.common.base.AbstractController;
import org.publiccms.entities.log.LogUpload;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.site.FileComponent;
import org.publiccms.logic.service.log.LogUploadService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"file"})
public class FileAdminController
extends AbstractController {
    @Autowired
    private FileComponent fileComponent;
    @Autowired
    protected LogUploadService logUploadService;

    @RequestMapping(value={"doUpload"}, method={RequestMethod.POST})
    public String upload(MultipartFile file, String field, Boolean onlyImage, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        if (null != file && !file.isEmpty()) {
            String fileName = this.fileComponent.getUploadFileName(this.fileComponent.getSuffix(file.getOriginalFilename()));
            try {
                this.fileComponent.upload(file, this.siteComponent.getWebFilePath(site, fileName));
                model.put((Object)"field", (Object)field);
                model.put((Object)field, (Object)fileName);
                this.logUploadService.save(new LogUpload(site.getId(), FileAdminController.getAdminFromSession(session).getId(), "web_manager", onlyImage, file.getSize(), RequestUtils.getIpAddress(request), CommonUtils.getDate(), fileName));
            }
            catch (IOException | IllegalStateException e) {
                this.log.error((Object)e.getMessage());
                return "common/uploadResult";
            }
        }
        return "common/uploadResult";
    }
}

