/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.home;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.ControllerUtils;
import com.publiccms.common.tools.JsonUtils;
import com.publiccms.common.tools.RequestUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.publiccms.common.base.AbstractController;
import org.publiccms.entities.home.HomeBroadcast;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.service.home.HomeBroadcastService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"homeBroadcast"})
public class HomeBroadcastAdminController
extends AbstractController {
    @Autowired
    private HomeBroadcastService service;

    @RequestMapping(value={"enable"}, method={RequestMethod.POST})
    public String enable(Long id, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (ControllerUtils.verifyEquals("admin.operate", HomeBroadcastAdminController.getAdminFromSession(session).getId(), id, model)) {
            return "common/ajaxError";
        }
        HomeBroadcast entity = (HomeBroadcast)this.service.getEntity(id);
        if (null != entity) {
            SysSite site = this.getSite(request);
            if (ControllerUtils.verifyNotEquals("siteId", site.getId(), entity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            this.service.updateStatus(id, false);
            this.logOperateService.save(new LogOperate(site.getId(), HomeBroadcastAdminController.getAdminFromSession(session).getId(), "web_manager", "enable.home.broadcast", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"disable"}, method={RequestMethod.POST})
    public String disable(Long id, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (ControllerUtils.verifyEquals("admin.operate", HomeBroadcastAdminController.getAdminFromSession(session).getId(), id, model)) {
            return "common/ajaxError";
        }
        HomeBroadcast entity = (HomeBroadcast)this.service.getEntity(id);
        if (null != entity) {
            SysSite site = this.getSite(request);
            if (ControllerUtils.verifyNotEquals("siteId", site.getId(), entity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            this.service.updateStatus(id, true);
            this.logOperateService.save(new LogOperate(site.getId(), HomeBroadcastAdminController.getAdminFromSession(session).getId(), "web_manager", "disable.home.broadcast", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }
}

