/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.cms;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.ControllerUtils;
import com.publiccms.common.tools.JsonUtils;
import com.publiccms.common.tools.RequestUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.publiccms.common.base.AbstractController;
import org.publiccms.entities.cms.CmsWord;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.service.cms.CmsWordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"cmsWord"})
public class CmsWordAdminController
extends AbstractController {
    private String[] ignoreProperties = new String[]{"id", "siteId"};
    @Autowired
    private CmsWordService service;

    @RequestMapping(value={"save"})
    public String save(CmsWord entity, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        if (null != entity.getId()) {
            CmsWord oldEntity = (CmsWord)this.service.getEntity(entity.getId());
            if (null == oldEntity || ControllerUtils.verifyNotEquals("siteId", site.getId(), oldEntity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            if (null != (entity = this.service.update(entity.getId(), entity, this.ignoreProperties))) {
                this.logOperateService.save(new LogOperate(entity.getSiteId(), CmsWordAdminController.getAdminFromSession(session).getId(), "web_manager", "update.word", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
            }
        } else {
            entity.setSiteId(site.getId());
            this.service.save(entity);
            this.logOperateService.save(new LogOperate(site.getId(), CmsWordAdminController.getAdminFromSession(session).getId(), "web_manager", "save.word", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"delete"})
    public String delete(Long id, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        CmsWord entity = (CmsWord)this.service.getEntity(id);
        if (null != entity) {
            if (ControllerUtils.verifyNotEquals("siteId", site.getId(), entity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            this.service.delete(id);
            this.logOperateService.save(new LogOperate(site.getId(), CmsWordAdminController.getAdminFromSession(session).getId(), "web_manager", "delete.word", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"hidden"})
    public String hidden(Long id, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        CmsWord entity = (CmsWord)this.service.getEntity(id);
        if (null != entity) {
            if (ControllerUtils.verifyNotEquals("siteId", site.getId(), entity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            this.service.updateStatus(id, true);
            this.logOperateService.save(new LogOperate(site.getId(), CmsWordAdminController.getAdminFromSession(session).getId(), "web_manager", "hidden.word", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"show"})
    public String show(Long id, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        CmsWord entity = (CmsWord)this.service.getEntity(id);
        if (null != entity) {
            if (ControllerUtils.verifyNotEquals("siteId", site.getId(), entity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            this.service.updateStatus(id, false);
            this.logOperateService.save(new LogOperate(site.getId(), CmsWordAdminController.getAdminFromSession(session).getId(), "web_manager", "show.word", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }
}

