/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.cms;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.ControllerUtils;
import com.publiccms.common.tools.RequestUtils;
import com.publiccms.common.tools.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.publiccms.common.base.AbstractController;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.log.LogUpload;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.site.FileComponent;
import org.publiccms.logic.service.log.LogUploadService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"cmsWebFile"})
public class CmsWebFileAdminController
extends AbstractController {
    @Autowired
    private FileComponent fileComponent;
    @Autowired
    protected LogUploadService logUploadService;

    @RequestMapping(value={"doUpload"})
    public String upload(MultipartFile file, String path, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (null != file && !file.isEmpty()) {
            try {
                SysSite site = this.getSite(request);
                path = path + "/" + file.getOriginalFilename();
                this.fileComponent.upload(file, this.siteComponent.getWebFilePath(site, path));
                this.logUploadService.save(new LogUpload(site.getId(), CmsWebFileAdminController.getAdminFromSession(session).getId(), "web_manager", false, file.getSize(), RequestUtils.getIpAddress(request), CommonUtils.getDate(), path));
            }
            catch (IOException e) {
                model.put((Object)"error", (Object)e.getMessage());
                this.log.error((Object)e.getMessage());
                return "common/ajaxError";
            }
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"delete"})
    public String delete(String[] paths, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (CommonUtils.notEmpty(paths)) {
            SysSite site = this.getSite(request);
            for (String path : paths) {
                String filePath = this.siteComponent.getWebFilePath(site, path);
                if (!ControllerUtils.verifyCustom("notExist.webfile", !this.fileComponent.deleteFile(filePath), (Map<String, Object>)model)) continue;
                return "common/ajaxError";
            }
            this.logOperateService.save(new LogOperate(site.getId(), CmsWebFileAdminController.getAdminFromSession(session).getId(), "web_manager", "delete.web.webfile", RequestUtils.getIpAddress(request), CommonUtils.getDate(), StringUtils.join((Object[])paths, (char)',')));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"zip"})
    public String doZip(String path, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (CommonUtils.notEmpty(path)) {
            SysSite site = this.getSite(request);
            String filePath = this.siteComponent.getWebFilePath(site, path);
            File file = new File(filePath);
            if (CommonUtils.notEmpty(file) && file.isDirectory()) {
                try {
                    ZipUtils.zip(filePath, filePath + ".zip");
                }
                catch (IOException e) {
                    model.put((Object)"error", (Object)e.getMessage());
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            this.logOperateService.save(new LogOperate(site.getId(), CmsWebFileAdminController.getAdminFromSession(session).getId(), "web_manager", "zip.web.webfile", RequestUtils.getIpAddress(request), CommonUtils.getDate(), path));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"unzip"})
    public String doUnzip(String path, HttpServletRequest request, HttpSession session, ModelMap model) {
        this.doUnzip(path, false, request, session, model);
        return "common/ajaxDone";
    }

    @RequestMapping(value={"unzipHere"})
    public String doUnzipHere(String path, HttpServletRequest request, HttpSession session, ModelMap model) {
        this.doUnzip(path, true, request, session, model);
        return "common/ajaxDone";
    }

    private void doUnzip(String path, boolean here, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (CommonUtils.notEmpty(path) && path.toLowerCase().endsWith(".zip")) {
            SysSite site = this.getSite(request);
            String filePath = this.siteComponent.getWebFilePath(site, path);
            File file = new File(filePath);
            if (CommonUtils.notEmpty(file) && file.isFile()) {
                try {
                    if (here) {
                        ZipUtils.unzipHere(filePath);
                    } else {
                        ZipUtils.unzip(filePath, filePath.substring(0, filePath.length() - 4), true);
                    }
                }
                catch (IOException e) {
                    model.put((Object)"error", (Object)e.getMessage());
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            this.logOperateService.save(new LogOperate(site.getId(), CmsWebFileAdminController.getAdminFromSession(session).getId(), "web_manager", "unzip.web.webfile", RequestUtils.getIpAddress(request), CommonUtils.getDate(), path));
        }
    }

    @RequestMapping(value={"createDirectory"})
    public String createDirectory(String path, String fileName, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (null != path && CommonUtils.notEmpty(fileName)) {
            SysSite site = this.getSite(request);
            path = path + "/" + fileName;
            String filePath = this.siteComponent.getWebFilePath(site, path);
            File file = new File(filePath);
            file.mkdirs();
            this.logOperateService.save(new LogOperate(site.getId(), CmsWebFileAdminController.getAdminFromSession(session).getId(), "web_manager", "createDirectory.web.webfile", RequestUtils.getIpAddress(request), CommonUtils.getDate(), path));
        }
        return "common/ajaxDone";
    }
}

