/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.cms;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.ControllerUtils;
import com.publiccms.common.tools.JsonUtils;
import com.publiccms.common.tools.RequestUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.publiccms.common.base.AbstractController;
import org.publiccms.entities.cms.CmsVote;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.service.cms.CmsVoteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"cmsVote"})
public class CmsVoteAdminController
extends AbstractController {
    @Autowired
    private CmsVoteService service;
    private String[] ignoreProperties = new String[]{"id", "siteId", "itemExtendId", "userCounts"};

    @RequestMapping(value={"save"})
    public String save(CmsVote entity, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        if (null != entity.getId()) {
            CmsVote oldEntity = (CmsVote)this.service.getEntity(entity.getId());
            if (null == oldEntity || ControllerUtils.verifyNotEquals("siteId", site.getId(), oldEntity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            if (null != (entity = this.service.update(entity.getId(), entity, this.ignoreProperties))) {
                this.logOperateService.save(new LogOperate(site.getId(), CmsVoteAdminController.getAdminFromSession(session).getId(), "web_manager", "update.vote", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
            }
        } else {
            entity.setSiteId(site.getId());
            this.service.save(entity);
            this.logOperateService.save(new LogOperate(site.getId(), CmsVoteAdminController.getAdminFromSession(session).getId(), "web_manager", "save.vote", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"delete"})
    public String delete(Integer id, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        CmsVote entity = (CmsVote)this.service.getEntity(id);
        if (null != entity) {
            if (ControllerUtils.verifyNotEquals("siteId", site.getId(), entity.getSiteId(), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            this.service.delete(id);
            this.logOperateService.save(new LogOperate(site.getId(), CmsVoteAdminController.getAdminFromSession(session).getId(), "web_manager", "delete.vote", RequestUtils.getIpAddress(request), CommonUtils.getDate(), JsonUtils.getString(entity)));
        }
        return "common/ajaxDone";
    }
}

