/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.cms;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.ControllerUtils;
import com.publiccms.common.tools.RequestUtils;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.publiccms.common.base.AbstractController;
import org.publiccms.common.constants.CommonConstants;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.cache.CacheComponent;
import org.publiccms.logic.component.site.FileComponent;
import org.publiccms.logic.component.site.SiteComponent;
import org.publiccms.logic.component.template.MetadataComponent;
import org.publiccms.logic.component.template.TemplateCacheComponent;
import org.publiccms.logic.component.template.TemplateComponent;
import org.publiccms.logic.service.cms.CmsPlaceService;
import org.publiccms.logic.service.sys.SysDeptPageService;
import org.publiccms.views.pojo.CmsPageMetadata;
import org.publiccms.views.pojo.CmsPlaceMetadata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"cmsTemplate"})
public class CmsTemplateAdminController
extends AbstractController {
    @Autowired
    private TemplateComponent templateComponent;
    @Autowired
    private TemplateCacheComponent templateCacheComponent;
    @Autowired
    private CacheComponent cacheComponent;
    @Autowired
    private MetadataComponent metadataComponent;
    @Autowired
    private FileComponent fileComponent;
    @Autowired
    private CmsPlaceService cmsPlaceService;
    @Autowired
    private SysDeptPageService sysDeptPageService;

    @RequestMapping(value={"save"})
    public String save(String path, String content, HttpServletRequest request, HttpSession session, ModelMap model) {
        SysSite site = this.getSite(request);
        if (CommonUtils.notEmpty(path)) {
            try {
                String filePath = this.siteComponent.getWebTemplateFilePath(site, path);
                File templateFile = new File(filePath);
                CmsPageMetadata metadata = this.metadataComponent.getTemplateMetadata(filePath);
                if (CommonUtils.notEmpty(templateFile)) {
                    this.fileComponent.updateFile(templateFile, content);
                    if (CommonUtils.notEmpty(metadata.getCacheTime()) && metadata.getCacheTime() > 0) {
                        this.templateCacheComponent.deleteCachedFile(SiteComponent.getFullFileName(site, path));
                    }
                    this.logOperateService.save(new LogOperate(site.getId(), CmsTemplateAdminController.getAdminFromSession(session).getId(), "web_manager", "update.web.template", RequestUtils.getIpAddress(request), CommonUtils.getDate(), path));
                } else {
                    this.fileComponent.createFile(templateFile, content);
                    this.logOperateService.save(new LogOperate(site.getId(), CmsTemplateAdminController.getAdminFromSession(session).getId(), "web_manager", "save.web.template", RequestUtils.getIpAddress(request), CommonUtils.getDate(), path));
                }
                this.templateComponent.clearTemplateCache();
                this.cacheComponent.clearViewCache();
                if (CommonUtils.notEmpty(metadata.getPublishPath())) {
                    this.publish(site, path);
                }
            }
            catch (TemplateException | IOException e) {
                model.put((Object)"error", (Object)e.getMessage());
                this.log.error((Object)e.getMessage());
                return "common/ajaxError";
            }
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"doUpload"})
    public String upload(MultipartFile file, String path, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (null != file && !file.isEmpty()) {
            try {
                SysSite site = this.getSite(request);
                path = path + "/" + file.getOriginalFilename();
                this.fileComponent.upload(file, this.siteComponent.getWebTemplateFilePath(site, path));
                this.logOperateService.save(new LogOperate(site.getId(), CmsTemplateAdminController.getAdminFromSession(session).getId(), "web_manager", "upload.web.template", RequestUtils.getIpAddress(request), CommonUtils.getDate(), path));
            }
            catch (IOException e) {
                model.put((Object)"error", (Object)e.getMessage());
                this.log.error((Object)e.getMessage());
                return "common/ajaxError";
            }
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"delete"})
    public String delete(String path, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (CommonUtils.notEmpty(path)) {
            SysSite site = this.getSite(request);
            String filePath = this.siteComponent.getWebTemplateFilePath(site, path);
            CmsPageMetadata metadata = this.metadataComponent.getTemplateMetadata(filePath);
            if (CommonUtils.notEmpty(metadata.getCacheTime()) && metadata.getCacheTime() > 0) {
                this.templateCacheComponent.deleteCachedFile(SiteComponent.getFullFileName(site, path));
            }
            if (ControllerUtils.verifyCustom("notExist.template", !this.fileComponent.deleteFile(filePath), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            this.metadataComponent.deleteTemplateMetadata(filePath);
            this.sysDeptPageService.delete(null, path);
            this.templateComponent.clearTemplateCache();
            this.cacheComponent.clearViewCache();
            this.logOperateService.save(new LogOperate(site.getId(), CmsTemplateAdminController.getAdminFromSession(session).getId(), "web_manager", "delete.web.template", RequestUtils.getIpAddress(request), CommonUtils.getDate(), path));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"deletePlace"})
    public String deletePlace(String path, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (CommonUtils.notEmpty(path)) {
            SysSite site = this.getSite(request);
            String filePath = this.siteComponent.getWebTemplateFilePath(site, TemplateComponent.INCLUDE_DIRECTORY + path);
            if (ControllerUtils.verifyCustom("notExist.template", !this.fileComponent.deleteFile(filePath), (Map<String, Object>)model)) {
                return "common/ajaxError";
            }
            this.metadataComponent.deletePlaceMetadata(filePath);
            this.cmsPlaceService.delete((int)site.getId(), path);
            this.templateComponent.clearTemplateCache();
            this.cacheComponent.clearViewCache();
            this.logOperateService.save(new LogOperate(site.getId(), CmsTemplateAdminController.getAdminFromSession(session).getId(), "web_manager", "delete.web.template", RequestUtils.getIpAddress(request), CommonUtils.getDate(), path));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"savePlaceMetaData"})
    public String savePlaceMetaData(String path, @ModelAttribute CmsPlaceMetadata metadata, String content, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (CommonUtils.notEmpty(path)) {
            SysSite site = this.getSite(request);
            String filePath = this.siteComponent.getWebTemplateFilePath(site, TemplateComponent.INCLUDE_DIRECTORY + path);
            try {
                File templateFile = new File(filePath);
                if (CommonUtils.empty(templateFile)) {
                    this.fileComponent.createFile(templateFile, content);
                }
                this.metadataComponent.updatePlaceMetadata(filePath, metadata);
                this.templateComponent.clearTemplateCache();
                this.cacheComponent.clearViewCache();
                this.logOperateService.save(new LogOperate(site.getId(), CmsTemplateAdminController.getAdminFromSession(session).getId(), "web_manager", "update.template.meta", RequestUtils.getIpAddress(request), CommonUtils.getDate(), path));
            }
            catch (IOException e) {
                model.put((Object)"error", (Object)e.getMessage());
                this.log.error((Object)e.getMessage());
                return "common/ajaxError";
            }
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"saveMetaData"})
    public String saveMetadata(String path, @ModelAttribute CmsPageMetadata metadata, String content, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (CommonUtils.notEmpty(path)) {
            if (path.endsWith("/") || CommonUtils.empty(path)) {
                path = path + CommonConstants.getDefaultPage();
            }
            SysSite site = this.getSite(request);
            String filePath = this.siteComponent.getWebTemplateFilePath(site, path);
            try {
                CmsPageMetadata oldmetadata;
                File templateFile = new File(filePath);
                if (CommonUtils.empty(templateFile)) {
                    this.fileComponent.createFile(templateFile, content);
                }
                if (null != (oldmetadata = this.metadataComponent.getTemplateMetadata(filePath))) {
                    metadata.setExtendDataList(oldmetadata.getExtendDataList());
                }
                this.metadataComponent.updateTemplateMetadata(filePath, metadata);
                this.templateComponent.clearTemplateCache();
                this.cacheComponent.clearViewCache();
                if (CommonUtils.notEmpty(metadata.getPublishPath())) {
                    this.publish(site, path);
                }
                this.logOperateService.save(new LogOperate(site.getId(), CmsTemplateAdminController.getAdminFromSession(session).getId(), "web_manager", "update.template.meta", RequestUtils.getIpAddress(request), CommonUtils.getDate(), path));
            }
            catch (TemplateException | IOException e) {
                model.put((Object)"error", (Object)e.getMessage());
                this.log.error((Object)e.getMessage());
                return "common/ajaxError";
            }
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"publishPlace"})
    public String publishPlace(String path, HttpServletRequest request, HttpSession session, ModelMap model) {
        try {
            SysSite site = this.getSite(request);
            if (CommonUtils.notEmpty(path) && site.isUseSsi()) {
                CmsPlaceMetadata metadata = this.metadataComponent.getPlaceMetadata(this.siteComponent.getWebTemplateFilePath(site, TemplateComponent.INCLUDE_DIRECTORY + path));
                this.templateComponent.staticPlace(site, path, metadata);
                this.logOperateService.save(new LogOperate(site.getId(), CmsTemplateAdminController.getAdminFromSession(session).getId(), "web_manager", "static", RequestUtils.getIpAddress(request), CommonUtils.getDate(), path));
            }
            return "common/ajaxDone";
        }
        catch (TemplateException | IOException e) {
            model.put((Object)"error", (Object)e.getMessage());
            this.log.error((Object)e.getMessage());
            return "common/ajaxError";
        }
    }

    @RequestMapping(value={"publish"})
    public String publish(String path, HttpServletRequest request, HttpSession session, ModelMap model) {
        try {
            SysSite site = this.getSite(request);
            this.publish(site, path);
            return "common/ajaxDone";
        }
        catch (TemplateException | IOException e) {
            model.put((Object)"error", (Object)e.getMessage());
            this.log.error((Object)e.getMessage());
            return "common/ajaxError";
        }
    }

    private void publish(SysSite site, String path) throws IOException, TemplateException {
        if (CommonUtils.notEmpty(path)) {
            CmsPageMetadata metadata = this.metadataComponent.getTemplateMetadata(this.siteComponent.getWebTemplateFilePath(site, path));
            if (site.isUseStatic() && CommonUtils.notEmpty(metadata.getPublishPath())) {
                this.templateComponent.createStaticFile(site, SiteComponent.getFullFileName(site, path), metadata.getPublishPath(), null, metadata, null);
            }
        }
    }
}

