/*
 * Decompiled with CFR 0.152.
 */
package org.publiccms.controller.admin.cms;

import com.publiccms.common.tools.CommonUtils;
import com.publiccms.common.tools.ControllerUtils;
import com.publiccms.common.tools.RequestUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.publiccms.common.base.AbstractController;
import org.publiccms.common.tools.ExtendUtils;
import org.publiccms.entities.cms.CmsPlace;
import org.publiccms.entities.log.LogOperate;
import org.publiccms.entities.sys.SysSite;
import org.publiccms.logic.component.template.MetadataComponent;
import org.publiccms.logic.component.template.TemplateComponent;
import org.publiccms.logic.service.cms.CmsPlaceAttributeService;
import org.publiccms.logic.service.cms.CmsPlaceService;
import org.publiccms.views.pojo.CmsPlaceParamters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"cmsPlace"})
public class CmsPlaceAdminController
extends AbstractController {
    @Autowired
    private CmsPlaceService service;
    @Autowired
    private CmsPlaceAttributeService attributeService;
    @Autowired
    private MetadataComponent metadataComponent;
    private String[] ignoreProperties = new String[]{"id", "siteId", "status", "userId", "type", "clicks", "path", "createDate", "disabled"};

    @RequestMapping(value={"save"}, method={RequestMethod.POST})
    public String save(CmsPlace entity, @ModelAttribute CmsPlaceParamters placeParamters, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (null != entity && CommonUtils.notEmpty(entity.getPath())) {
            entity.setPath(entity.getPath().replace("//", "/"));
            SysSite site = this.getSite(request);
            Long userId = CmsPlaceAdminController.getAdminFromSession(session).getId();
            if (CommonUtils.empty(entity.getItemType()) || CommonUtils.empty(entity.getItemId())) {
                entity.setItemType("custom");
                entity.setItemId(null);
            }
            if (null != entity.getId()) {
                CmsPlace oldEntity = (CmsPlace)this.service.getEntity(entity.getId());
                if (null == oldEntity || ControllerUtils.verifyNotEquals("siteId", site.getId(), oldEntity.getSiteId(), (Map<String, Object>)model)) {
                    return "common/ajaxError";
                }
                if (null != (entity = this.service.update(entity.getId(), entity, this.ignoreProperties))) {
                    this.logOperateService.save(new LogOperate(site.getId(), userId, "web_manager", "update.place", RequestUtils.getIpAddress(request), CommonUtils.getDate(), entity.getPath()));
                }
            } else {
                entity.setUserId(userId);
                entity.setSiteId(site.getId());
                entity.setStatus(1);
                this.service.save(entity);
                this.logOperateService.save(new LogOperate(site.getId(), userId, "web_manager", "save.place", RequestUtils.getIpAddress(request), CommonUtils.getDate(), entity.getPath()));
            }
            String filePath = this.siteComponent.getWebTemplateFilePath(site, TemplateComponent.INCLUDE_DIRECTORY + entity.getPath());
            Map<String, String> map = ExtendUtils.getExtentDataMap(placeParamters.getExtendDataList(), this.metadataComponent.getPlaceMetadata(filePath).getExtendList());
            String extentString = ExtendUtils.getExtendString(map);
            this.attributeService.updateAttribute(entity.getId(), extentString);
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"refresh"})
    public String refresh(Long[] ids, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (CommonUtils.notEmpty(ids)) {
            SysSite site = this.getSite(request);
            this.service.refresh(site.getId(), ids);
            this.logOperateService.save(new LogOperate(site.getId(), CmsPlaceAdminController.getAdminFromSession(session).getId(), "web_manager", "refresh.place", RequestUtils.getIpAddress(request), CommonUtils.getDate(), StringUtils.join((Object[])ids, (char)',')));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"check"})
    public String check(Long[] ids, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (CommonUtils.notEmpty(ids)) {
            SysSite site = this.getSite(request);
            this.service.check(site.getId(), ids);
            this.logOperateService.save(new LogOperate(site.getId(), CmsPlaceAdminController.getAdminFromSession(session).getId(), "web_manager", "check.place", RequestUtils.getIpAddress(request), CommonUtils.getDate(), StringUtils.join((Object[])ids, (char)',')));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"clear"})
    public String clear(String path, HttpServletRequest request, HttpSession session, ModelMap model) {
        if (CommonUtils.notEmpty(path)) {
            SysSite site = this.getSite(request);
            this.service.delete((int)site.getId(), path);
            this.logOperateService.save(new LogOperate(site.getId(), CmsPlaceAdminController.getAdminFromSession(session).getId(), "web_manager", "clear.place", RequestUtils.getIpAddress(request), CommonUtils.getDate(), path));
        }
        return "common/ajaxDone";
    }

    @RequestMapping(value={"delete"})
    public String delete(Long[] ids, HttpServletRequest request, HttpSession session) {
        if (CommonUtils.notEmpty(ids)) {
            SysSite site = this.getSite(request);
            this.service.delete((int)site.getId(), ids);
            this.logOperateService.save(new LogOperate(site.getId(), CmsPlaceAdminController.getAdminFromSession(session).getId(), "web_manager", "delete.place", RequestUtils.getIpAddress(request), CommonUtils.getDate(), StringUtils.join((Object[])ids, (char)',')));
        }
        return "common/ajaxDone";
    }
}

